/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JLabel;
import utils.ktsmate.gui.renderer.WiggleStroke;

public class StrikeoutLabel
extends JLabel {
    public static final Stroke DASHED = new BasicStroke(2.0f, 0, 0, 1.0f, new float[]{3.0f, 5.0f}, 0.0f);
    public static final Stroke SOLID = new BasicStroke(2.0f);
    public static final Stroke WIGGLE = new WiggleStroke(new BasicStroke(2.0f));
    private float startMultiplier = 0.5f;
    private float endMultiplier = 0.5f;
    private Color strikeoutColor;
    private Stroke stroke;

    public StrikeoutLabel(String text) {
        this(text, null);
    }

    public StrikeoutLabel(String text, Stroke strokeToUse) {
        super(text);
        this.stroke = strokeToUse != null ? strokeToUse : SOLID;
    }

    public void setStartEnd(float start, float end) {
        this.startMultiplier = start;
        this.endMultiplier = end;
    }

    public void setStrikeoutColour(Color newColor) {
        this.strikeoutColor = newColor;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.strikeoutColor != null && this.stroke != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.strikeoutColor);
            g2.setStroke(this.stroke);
            g2.drawLine(0, (int)((float)this.getHeight() * this.startMultiplier), this.getWidth(), (int)((float)this.getHeight() * this.endMultiplier));
        }
    }

    public void setStrikeoutStroke(Stroke toUse) {
        this.stroke = toUse;
    }
}

