/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.renderer;

import au.com.ordermate.units.SalesQuantity;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import ordermate.OrderMate;
import ordermate.database.gui.FontAttributes;
import ordermate.database.sales.TableAccount;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.docket.line.SummaryGroupLine;
import utils.ktsmate.docket.line.SummaryItemLine;
import utils.ktsmate.docket.line.SummaryLine;
import utils.ktsmate.gui.renderer.LineRenderer;
import utils.ktsmate.gui.renderer.LineRendererHelper;
import utils.ktsmate.gui.renderer.StrikeoutLabel;

public abstract class SummaryLineRenderer<T>
implements LineRenderer<T> {
    private Color deletedColour;
    private Color transferredColour;
    private Color completedColour;
    private FontAttributes fontAttributes;
    private JComponent renderer;
    private StrikeoutLabel alteredQtyLabel;
    private StrikeoutLabel qtyLabel;
    private JLabel seatsLabel;
    private boolean useSeatNums;
    private SummaryLine<T> line;

    public SummaryLineRenderer(SummaryLine<T> toRender, Color completed, Color deleted, Color transferred, FontAttributes attributes, KTSDocket theDocket) {
        this.line = toRender;
        this.completedColour = completed;
        this.fontAttributes = attributes;
        this.deletedColour = deleted;
        this.transferredColour = transferred;
        this.useSeatNums = !this.line.getSummaries().isEmpty() ? this.line.getSummaries().get(0).getSalesItem().getAccount() instanceof TableAccount && theDocket.getTerminal() != null && theDocket.getTerminal().getSeatNums() : false;
        this.createRenderer();
    }

    private void createRenderer() {
        this.alteredQtyLabel = new StrikeoutLabel("");
        this.qtyLabel = new StrikeoutLabel("");
        this.qtyLabel.setOpaque(false);
        Font font = this.fontAttributes.generateFont();
        this.qtyLabel.setFont(font);
        this.renderer = new JPanel(new FlowLayout(0, 0, 0));
        this.renderer.setBackground(Color.ORANGE);
        this.renderer.setOpaque(false);
        this.alteredQtyLabel.setFont(font);
        this.alteredQtyLabel.setStartEnd(1.0f, 0.0f);
        this.alteredQtyLabel.setVisible(false);
        this.alteredQtyLabel.setOpaque(false);
        if (this.line.getParent() != null) {
            this.renderer.setBorder(new EmptyBorder(0, 10, 0, 0));
        }
        this.renderer.add(this.alteredQtyLabel);
        this.renderer.add(this.qtyLabel);
        if (this.useSeatNums) {
            this.seatsLabel = new JLabel("");
            this.seatsLabel.setForeground(Color.GRAY);
            this.seatsLabel.setOpaque(false);
            this.renderer.add(this.seatsLabel);
        }
        this.refreshRenderingComponent();
    }

    @Override
    public void refreshRenderingComponent() {
        block10: {
            try {
                SalesQuantity qty = this.line.getQuantity();
                StringBuilder qtyBuilder = new StringBuilder(qty.toString()).append(" ").append(this.getLabel());
                this.qtyLabel.setText(qtyBuilder.toString());
                if (this.useSeatNums) {
                    if (this.line instanceof SummaryItemLine || this.line instanceof SummaryGroupLine) {
                        this.seatsLabel.setText("   " + this.line.getSeats());
                    } else if (!this.line.getSummaries().isEmpty()) {
                        this.seatsLabel.setText("   " + this.line.getSummaries().get(0).getSeatNumbersAsString(true, true, false, null));
                    }
                    if (this.seatsLabel.getFont() == null || this.seatsLabel.getFont().getSize() > this.fontAttributes.getPointSize()) {
                        this.seatsLabel.setFont(this.fontAttributes.generateFont());
                    }
                }
                if (this.line.getOldQuantity() != null) {
                    StringBuilder SB = new StringBuilder(" ").append(this.line.getOldQuantity()).append(" ");
                    this.alteredQtyLabel.setText(SB.toString());
                    this.alteredQtyLabel.setStrikeoutColour(this.deletedColour);
                    this.alteredQtyLabel.setStrikeoutStroke(StrikeoutLabel.SOLID);
                    this.alteredQtyLabel.setVisible(true);
                    this.alteredQtyLabel.invalidate();
                }
                if (qty.equals(0L)) {
                    this.doZeroQuantity();
                } else {
                    this.doNonZeroQuantity();
                }
                this.renderer.setOpaque(this.line.isHighlighted());
            }
            catch (Exception ex) {
                String errText = "Could not display";
                if (errText.equals(this.qtyLabel.getText())) break block10;
                OrderMate.LOG.error("An exception occurred rendering the quantity", (Throwable)ex);
                this.qtyLabel.setText("Could not display");
            }
        }
        this.qtyLabel.invalidate();
        this.renderer.validate();
        this.renderer.repaint();
    }

    private void doZeroQuantity() {
        if (this.line.isComplete()) {
            this.qtyLabel.setStrikeoutColour(this.completedColour);
            this.qtyLabel.setStrikeoutStroke(StrikeoutLabel.SOLID);
        } else {
            this.qtyLabel.setStrikeoutStroke(StrikeoutLabel.WIGGLE);
            this.qtyLabel.setStrikeoutColour(this.deletedColour);
        }
    }

    private void doNonZeroQuantity() {
        String itemState = this.line.getItemState();
        if (this.line.isComplete()) {
            this.qtyLabel.setStrikeoutColour(this.completedColour);
            this.qtyLabel.setStrikeoutStroke(StrikeoutLabel.SOLID);
        } else {
            this.qtyLabel.setStrikeoutColour(null);
        }
        if (itemState.equals("DELETED") || itemState.equals("DELETED_WASTED")) {
            this.qtyLabel.setBackground(this.deletedColour);
        } else if (itemState.equals("MOVED")) {
            this.qtyLabel.setBackground(this.transferredColour);
        } else {
            this.qtyLabel.setBackground(null);
        }
    }

    @Override
    public KTSLine<T> getRenderedLine() {
        return this.line;
    }

    @Override
    public JComponent getRenderingComponent() {
        return this.renderer;
    }

    @Override
    public void adjustRendererHeightToFit(int width) {
        if (this.useSeatNums) {
            int preferredHeight = LineRendererHelper.getPreferredHeightFromNewWidth(this.qtyLabel.getHeight(), this.seatsLabel.getHeight(), width, Arrays.asList(this.qtyLabel, this.seatsLabel));
            this.renderer.setPreferredSize(new Dimension(width, preferredHeight));
        } else {
            this.renderer.setPreferredSize(new Dimension(width, this.qtyLabel.getY() + this.qtyLabel.getHeight()));
        }
        this.renderer.invalidate();
    }

    protected SummaryLine<T> getSummaryLine() {
        return this.line;
    }

    protected abstract String getLabel();
}

