/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.renderer;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;

public class WiggleStroke
implements Stroke {
    private float amplitude = 3.0f;
    private float wavelength = 6.0f;
    private Stroke stroke;
    private static final float FLATNESS = 1.0f;

    public WiggleStroke(Stroke compoundStroke) {
        this.stroke = compoundStroke;
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        GeneralPath newPath = new GeneralPath();
        FlatteningPathIterator it = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] points = new float[6];
        float moveX = 0.0f;
        float moveY = 0.0f;
        float lastX = 0.0f;
        float lastY = 0.0f;
        float thisX = 0.0f;
        float thisY = 0.0f;
        int type = 0;
        float next = 0.0f;
        int phase = 0;
        while (!it.isDone()) {
            type = it.currentSegment(points);
            if (type == 0) {
                moveX = lastX = points[0];
                moveY = lastY = points[1];
                newPath.moveTo(moveX, moveY);
                next = this.wavelength / 2.0f;
            } else if (type == 4) {
                points[0] = moveX;
                points[1] = moveY;
            }
            if (type == 1 || type == 4) {
                thisX = points[0];
                float dx = thisX - lastX;
                thisY = points[1];
                float dy = thisY - lastY;
                float distance = (float)Math.sqrt(dx * dx + dy * dy);
                if (distance >= next) {
                    float r = 1.0f / distance;
                    while (distance >= next) {
                        float rx = dx * r;
                        float ry = dy * r;
                        float x = lastX + next * rx;
                        float y = lastY + next * ry;
                        if (!(phase & true)) {
                            newPath.lineTo(x + this.amplitude * ry, y - this.amplitude * rx);
                        } else {
                            newPath.lineTo(x - this.amplitude * ry, y + this.amplitude * rx);
                        }
                        next += this.wavelength;
                        ++phase;
                    }
                }
                next -= distance;
                lastX = thisX;
                lastY = thisY;
                if (type == 4) {
                    newPath.closePath();
                }
            }
            it.next();
        }
        return this.stroke.createStrokedShape(newPath);
    }
}

