/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.summary;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.gui.themes.OrderMateTheme;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.gui.renderer.DefaultLineRendererFactory;
import utils.ktsmate.gui.renderer.LineRenderer;
import utils.ktsmate.gui.summary.KTSSummaryStatusTogglePanel;
import utils.ktsmate.summary.KTSDocketSource;
import utils.ktsmate.summary.KTSSummaryPipeline;

public class KTSSummaryPanel
extends JPanel {
    private KTSDocketSource sourcer;
    private KTSSummaryPipeline pipeline;
    private KTSSummaryStatusTogglePanel togglePanel;
    private JPanel summaryPanel;
    private JScrollPane summaryScrollPane;

    public KTSSummaryPanel(KTSDocketSource docketSourcer, KTSSummaryPipeline pipeline) {
        this.sourcer = docketSourcer;
        this.pipeline = pipeline;
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)this.createHeaderPanel(), constraints);
        constraints.gridy = 1;
        this.add((Component)this.createDocketStatusTogglePanel(), constraints);
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.add((Component)this.createSummaryPanel(), constraints);
        this.updateScrollModel();
    }

    private JPanel createHeaderPanel() {
        JPanel headingPanel = new JPanel();
        JLabel headingLabel = new JLabel("Summary");
        headingLabel.setFont(OrderMateTheme.getVeryLargeFont());
        headingPanel.setBackground(Color.GRAY.brighter());
        headingPanel.setOpaque(true);
        headingPanel.setAlignmentX(0.5f);
        headingPanel.add(headingLabel);
        headingPanel.setBorder(new EtchedBorder(1));
        return headingPanel;
    }

    private JPanel createDocketStatusTogglePanel() {
        this.togglePanel = new KTSSummaryStatusTogglePanel(this);
        return this.togglePanel;
    }

    private JComponent createSummaryPanel() {
        this.summaryPanel = new JPanel();
        this.summaryPanel.setMaximumSize(new Dimension(this.getWidth(), 100000));
        this.summaryPanel.setLayout(new BoxLayout(this.summaryPanel, 1));
        this.summaryPanel.setAlignmentX(0.0f);
        this.summaryScrollPane = new JScrollPane(this.summaryPanel);
        this.summaryScrollPane.setHorizontalScrollBarPolicy(31);
        OrderMateTheme.setupScrollPane((JScrollPane)this.summaryScrollPane);
        return this.summaryScrollPane;
    }

    public void refresh() {
        if (this.getParent() != null) {
            this.updateScrollModel();
        }
    }

    private void updateScrollModel() {
        DefaultLineRendererFactory lineRendererFactory = new DefaultLineRendererFactory();
        Collection docketStates = KTSMate.getLocalPrinter().getQueuesToSummarise();
        KTSDocket dummyDocket = new KTSDocket(new SalesAccountDocket((VirtualPrinter)VirtualPrinter.getAllPrinters().get(0), "xml", "dockets", "docketType"));
        int scrollBarWidth = this.summaryScrollPane.getVerticalScrollBar().getWidth();
        this.summaryPanel.removeAll();
        for (KTSLine line : this.pipeline.process(this.sourcer.getDockets(docketStates))) {
            LineRenderer renderer = lineRendererFactory.createRenderer(dummyDocket, line, false);
            JComponent lineComponent = null;
            lineComponent = renderer.getRenderingComponent();
            lineComponent.setAlignmentX(0.0f);
            this.summaryPanel.add(lineComponent);
            renderer.adjustRendererHeightToFit(this.getWidth() - scrollBarWidth);
            this.summaryPanel.validate();
            renderer.adjustRendererHeightToFit(this.getWidth() - scrollBarWidth);
            this.summaryPanel.validate();
            Dimension preferredSize = lineComponent.getPreferredSize();
            if (line.getData() instanceof String) {
                preferredSize.height = (int)(preferredSize.getHeight() * 1.6);
                lineComponent.setPreferredSize(preferredSize);
                lineComponent.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
            }
            lineComponent.setMaximumSize(preferredSize);
        }
        this.repaint();
    }
}

