/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.summary;

import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.gui.button.CustomToggleButton;
import utils.ktsmate.KTSMate;
import utils.ktsmate.gui.summary.KTSSummaryPanel;

public class KTSSummaryStatusTogglePanel
extends JPanel
implements ActionListener {
    private CustomToggleButton liveToggle;
    private CustomToggleButton holdToggle;
    private CustomToggleButton bumpedToggle;
    private KTSSummaryPanel summaryPanel;

    public KTSSummaryStatusTogglePanel(KTSSummaryPanel summaryPanel) {
        this.setLayout(new GridLayout(1, 3));
        this.summaryPanel = summaryPanel;
        this.liveToggle = new CustomToggleButton((Displayable)AbstractDocket.DocketClassType.SALES_ACCOUNT);
        this.liveToggle.setText("Live");
        this.liveToggle.setSelected(KTSMate.getLocalPrinter().isSummariseLiveQueue());
        this.liveToggle.addActionListener((ActionListener)this);
        this.add((Component)this.liveToggle);
        this.holdToggle = new CustomToggleButton((Displayable)AbstractDocket.DocketClassType.SALES_ACCOUNT);
        this.holdToggle.setText("Hold");
        this.holdToggle.setSelected(KTSMate.getLocalPrinter().isSummariseHoldQueue());
        this.holdToggle.addActionListener((ActionListener)this);
        this.add((Component)this.holdToggle);
        this.bumpedToggle = new CustomToggleButton((Displayable)AbstractDocket.DocketClassType.SALES_ACCOUNT);
        this.bumpedToggle.setText("Bumped");
        this.bumpedToggle.setSelected(KTSMate.getLocalPrinter().isSummariseBumpedQueue());
        this.bumpedToggle.addActionListener((ActionListener)this);
        this.add((Component)this.bumpedToggle);
    }

    public Collection<KTSDocketState> getSelectedStates() {
        ArrayList<KTSDocketState> states = new ArrayList<KTSDocketState>();
        if (this.liveToggle.isSelected()) {
            states.add(KTSDocketState.Live);
        }
        if (this.holdToggle.isSelected()) {
            states.add(KTSDocketState.Hold);
        }
        if (this.bumpedToggle.isSelected()) {
            states.add(KTSDocketState.Bump);
        }
        return states;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.getSelectedStates().size() <= 0) {
            CustomToggleButton source;
            source.setSelected(!(source = (CustomToggleButton)event.getSource()).isSelected());
        }
        if (event.getSource() == this.liveToggle) {
            KTSMate.getLocalPrinter().setSummariseLiveQueue(this.liveToggle.isSelected());
        } else if (event.getSource() == this.holdToggle) {
            KTSMate.getLocalPrinter().setSummariseHoldQueue(this.holdToggle.isSelected());
        } else if (event.getSource() == this.bumpedToggle) {
            KTSMate.getLocalPrinter().setSummariseBumpedQueue(this.bumpedToggle.isSelected());
        }
        KTSMate.getLocalPrinter().save();
        this.summaryPanel.refresh();
    }
}

