/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.views;

import au.com.ordermate.OrderMateLog;
import ca.odell.glazedlists.EventList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.hardware.physical.kts.KTSCommand;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import utils.ktsmate.KTSNavBar;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSListController;
import utils.ktsmate.gui.views.GestureListener;
import utils.ktsmate.gui.views.TabularDocketListView;
import waitermate.guikit.AbstractScreen;

public abstract class AbstractDocketListView
extends AbstractScreen {
    private JPanel listPanel = new JPanel(new BorderLayout());
    private JPanel bumpOutPanel = new JPanel(new BorderLayout());
    private TabularDocketListView listView;
    private KTSNavBar navBar;
    protected KTSListController listController;
    private GestureListener gestureListener;
    private final EventList<KTSDocket> stateList;
    private boolean showBumpOutPanel;
    private int bumpOutPanelColumnWidth = 1;
    private int fullTableColumns;

    public AbstractDocketListView(KTSListController controller) {
        this.listController = controller;
        this.stateList = this.listController.getDocketList(this.getViewState());
        this.bumpOutPanel.setName("BumpOut");
        this.reestablishListView();
    }

    public List<KTSDocket> getSelectedDockets() {
        return new ArrayList<KTSDocket>(this.listView.getSelectedDockets());
    }

    public KTSDocket getSelectedDocket() {
        return this.listView.getSelectedDocket();
    }

    public void gotDocketSelected() {
        this.navBar.setFastMovesEnabled(!this.listView.getSelectedDockets().isEmpty());
    }

    public void gotDocketsMoved(KTSDocket selectedDocket, Integer index) {
        if (index == null) {
            OrderMateLog.LOG.warn("Somehow got a null index when moving dockets.");
            return;
        }
        ArrayList<KTSDocket> selectedDockets = new ArrayList<KTSDocket>(this.listView.getSelectedDockets());
        if (!selectedDockets.contains(selectedDocket)) {
            selectedDockets.add(0, selectedDocket);
        }
        this.listController.moveDockets(selectedDockets, this.getViewState(), index);
    }

    protected final TabularDocketListView getView() {
        return this.listView;
    }

    protected void updateTabularView() {
        this.listView.updateSelections();
    }

    public abstract KTSDocketState getViewState();

    @Override
    public JComponent getMainArea() {
        return this.listPanel;
    }

    @Override
    public KTSNavBar getNavBar() {
        if (this.navBar == null) {
            this.navBar = this.createNavBar();
            this.navBar.goNext.connect((Object)this, "gotGoNext");
            this.navBar.goPrevious.connect((Object)this, "gotGoPrevious");
            this.navBar.toEnd.connect((Object)this, "gotSendToEnd");
            this.navBar.toStart.connect((Object)this, "gotSendToStart");
        }
        return this.navBar;
    }

    public void gotSendToStart() {
        ArrayList<KTSDocket> selectedDockets = new ArrayList<KTSDocket>(this.listView.getSelectedDockets());
        this.listController.moveDockets(selectedDockets, this.getViewState(), 0);
        this.listView.deselectDockets();
        this.gotDocketSelected();
        this.listView.setFirstDocketIndex(this.listView.getFirstDocketIndex());
    }

    public void gotSendToEnd() {
        ArrayList<KTSDocket> selectedDockets = new ArrayList<KTSDocket>(this.listView.getSelectedDockets());
        this.listController.moveDockets(selectedDockets, this.getViewState(), this.listView.getNumDockets() + 1);
        this.listView.deselectDockets();
        this.gotDocketSelected();
        this.listView.setFirstDocketIndex(this.listView.getFirstDocketIndex());
    }

    public void gotGoNext() {
        this.listView.switchPage(true);
    }

    public void gotGoPrevious() {
        this.listView.switchPage(false);
    }

    public void gotListUpdated() {
        this.navBar.setIndexInfo(this.listView.getFirstDocketIndex(), this.listView.getLastDocketIndex(), this.listView.getNumDockets());
        this.gotDocketSelected();
    }

    public void viewParametersChanged() {
        this.reestablishListView();
    }

    @Override
    public void display() {
        super.display();
        this.updateRenderers();
    }

    @Override
    public void setUp() {
        super.setUp();
        this.updateRenderers();
    }

    public void updateRenderers() {
        this.listView.updateList();
    }

    public void setBumpOutPanelContents(JPanel contents) {
        this.clearBumpOutPanelContents();
        if (contents != null) {
            this.bumpOutPanel.add(contents);
        }
    }

    public void clearBumpOutPanelContents() {
        this.bumpOutPanel.removeAll();
    }

    public void setBumpOutPanelWidth(int columns) {
        this.bumpOutPanelColumnWidth = columns;
    }

    public void setShowBumpOutPanel(boolean show) {
        this.showBumpOutPanel = show;
    }

    private void showBumpOutPanel() {
        if (!this.isBumpOutPanelVisible()) {
            int listColumns = this.listView.getColumns();
            this.fullTableColumns = this.listView.getColumns();
            if (listColumns - this.bumpOutPanelColumnWidth <= 0) {
                listColumns = this.bumpOutPanelColumnWidth + 1;
            }
            this.bumpOutPanel.setPreferredSize(new Dimension(this.listPanel.getWidth() / listColumns * this.bumpOutPanelColumnWidth, this.listPanel.getHeight()));
            this.listPanel.add((Component)this.bumpOutPanel, "East");
            this.listView.setColumns(listColumns - this.bumpOutPanelColumnWidth);
            this.listPanel.validate();
        }
    }

    private void hideBumpOutPanel() {
        if (this.isBumpOutPanelVisible()) {
            this.listPanel.remove(this.bumpOutPanel);
            this.listView.setColumns(this.fullTableColumns);
            this.listPanel.validate();
        }
    }

    public boolean isBumpOutPanelVisible() {
        return this.bumpOutPanel.getParent() == this.listPanel;
    }

    public void uncoupleListView() {
        if (this.listView != null) {
            this.listView.setDocketList(null, null);
            this.listView.stopAnimations();
            this.listView.removeMouseMotionListener(this.gestureListener);
            this.listView.removeMouseListener(this.gestureListener);
            this.listView.listUpdated.disconnect((Object)this);
            this.listView.removeAll();
            this.listView = null;
        }
    }

    private void reestablishListView() {
        this.hideBumpOutPanel();
        this.uncoupleListView();
        this.listPanel.removeAll();
        this.listView = this.createListView();
        this.initViewAndGestureListener();
        this.listPanel.add(this.listView);
        this.listPanel.validate();
        this.listView.setDocketList(this.stateList, this.getViewState());
        if (this.showBumpOutPanel) {
            this.showBumpOutPanel();
        }
    }

    private void initViewAndGestureListener() {
        this.gestureListener = new GestureListener(this.listView);
        this.gestureListener.gotSelection.disconnectAll();
        this.gestureListener.gotSelection.connect((Object)this, "gotDocketSelected");
        this.gestureListener.gotMove.disconnectAll();
        this.gestureListener.gotMove.connect((Object)this, "gotDocketsMoved");
        this.listView.listUpdated.disconnectAll();
        this.listView.listUpdated.connect((Object)this, "gotListUpdated");
        this.listView.docketActioned.disconnectAll();
        this.listView.docketActioned.connect((Object)this, "gotDocketActioned");
    }

    public Integer getRelativePageFor(KTSDocket docket) {
        return this.listView.getRelativePageFor(docket);
    }

    public JComponent getRendererFor(KTSDocket docket) {
        return this.listView.getDocketViewIfExists(docket);
    }

    public boolean doCommand(KTSCommand command) {
        boolean handled = false;
        switch (command) {
            case SendToEnd: {
                handled = true;
                this.gotSendToEnd();
                break;
            }
            case SendToStart: {
                handled = true;
                this.gotSendToStart();
                break;
            }
            case NextPage: {
                handled = true;
                this.gotGoNext();
                break;
            }
            case PreviousPage: {
                handled = true;
                this.gotGoPrevious();
                break;
            }
            default: {
                handled = this.getView().doCommand(command);
            }
        }
        return handled;
    }

    protected abstract TabularDocketListView createListView();

    protected abstract KTSNavBar createNavBar();

    public abstract void gotDocketActioned(KTSDocket var1);
}

