/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.views;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import ordermate.database.hardware.physical.kts.KTSCommand;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import utils.ktsmate.KTSMate;
import utils.ktsmate.KTSNavBar;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSListController;
import utils.ktsmate.gui.views.AbstractDocketListView;
import utils.ktsmate.gui.views.DefaultDocketPanelFactory;
import utils.ktsmate.gui.views.TabularDocketListView;
import waitermate.guikit.ScreenResource;

public class BumpedView
extends AbstractDocketListView {
    private static final double DIALOG_FACTOR = 0.8;
    public final Signal back = Signals.createSignal();

    public BumpedView(KTSListController controller) {
        super(controller);
    }

    @Override
    protected TabularDocketListView createListView() {
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        Dimension frameSize = ScreenResource.getTarget().getSize();
        Dimension dialogSize = new Dimension((int)frameSize.getWidth(), (int)(frameSize.getHeight() * 0.8));
        return new TabularDocketListView(new DefaultDocketPanelFactory(), printer.getNumRows(), printer.getNumColumns(), printer.getAnimTime(), dialogSize);
    }

    @Override
    protected KTSNavBar createNavBar() {
        return new ClosedNav();
    }

    @Override
    public KTSDocketState getViewState() {
        return KTSDocketState.Bump;
    }

    public void gotRevive() {
        final List<KTSDocket> toRevive = this.getSelectedDockets();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (KTSDocket nextDocket : toRevive) {
                    BumpedView.this.listController.changeDocketState(nextDocket, KTSDocketState.Live, 0);
                }
            }
        });
    }

    @Override
    public void gotDocketSelected() {
        super.gotDocketSelected();
        ((ClosedNav)this.getNavBar()).reviveButton.setEnabled(!this.getView().getSelectedDockets().isEmpty());
    }

    @Override
    public boolean doCommand(KTSCommand command) {
        boolean handled = super.doCommand(command);
        if (!handled) {
            if (KTSCommand.Cancel.equals((Object)command)) {
                handled = true;
                this.getNavBar().back.emit();
            } else if (KTSCommand.Ok.equals((Object)command)) {
                handled = true;
                this.getNavBar().ok.emit();
            }
        }
        return handled;
    }

    @Override
    public void gotDocketActioned(KTSDocket docket) {
        this.getView().deselectDockets();
        this.getView().toggleDocketSelection(docket);
        this.gotRevive();
        this.clearBumpOutPanelContents();
    }

    private class ClosedNav
    extends KTSNavBar {
        private JButton backButton;
        private JButton reviveButton;

        private ClosedNav() {
        }

        @Override
        protected void setupNav() {
            super.setupNav();
            this.setText("<html>Tap the header of a <b>Bumped</b> docket<br>and hit OK to revive</html>");
            this.backButton = this.constructButton((Icon)IconLoader.get((String)"/utils/ktsmate/images/back.png"), "Cancel", "backButton", this.back);
            this.reviveButton = this.constructButton((Icon)IconLoader.get((String)"/utils/ktsmate/images/ok.png"), "OK", "unbumpButton", this.ok);
            this.reviveButton.setEnabled(false);
            this.ok.disconnectAll();
            this.ok.connect((Object)BumpedView.this, "gotRevive");
            this.addLeft(this.backButton, 0);
            this.addRight(this.reviveButton);
        }
    }
}

