/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.gui.renderer.LineRenderer;
import utils.ktsmate.gui.renderer.LineRendererFactory;

public class DocketItemsPanel
extends JPanel {
    private static final int DEFAULT_SCROLL_WIDTH = 48;
    private JComponent holder;
    private boolean isFull = false;
    private boolean drawSeparator = false;
    private final LineRendererFactory rendererFactory;

    public DocketItemsPanel(LineRendererFactory factory) {
        super(new FlowLayout(0));
        this.rendererFactory = factory;
        this.holder = new Box(1);
        this.holder.setAlignmentX(0.0f);
        this.add(this.holder);
    }

    public void setDrawSeparator(boolean value) {
        this.drawSeparator = value;
    }

    public LineRenderer addItemToRender(KTSDocket docket, KTSLine line, boolean includeCourse) {
        LineRenderer renderer = this.rendererFactory.createRenderer(docket, line, includeCourse);
        if (this.isFull) {
            return null;
        }
        JComponent rendComp = renderer.getRenderingComponent();
        if (rendComp.getBackground() == null) {
            rendComp.setOpaque(false);
        }
        rendComp.setAlignmentX(0.0f);
        rendComp.invalidate();
        this.holder.add(rendComp);
        this.validate();
        int myWidth = this.getWidth();
        renderer.adjustRendererHeightToFit(myWidth);
        this.validate();
        if ((double)this.holder.getHeight() > this.getPreferredSize().getHeight()) {
            if (this.holder.getComponents().length == 1) {
                this.swapForScroll(renderer);
            } else {
                rendComp.setPreferredSize(null);
                this.holder.remove(rendComp);
                renderer = null;
            }
            this.isFull = true;
        }
        return renderer;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.drawSeparator) {
            g.setColor(Color.GRAY);
            g.drawLine(0, 100, 0, this.getHeight() - 20);
        }
    }

    private void swapForScroll(LineRenderer renderer) {
        Component[] comps;
        this.remove(this.holder);
        JScrollPane scrolly = new JScrollPane(this.holder);
        scrolly.setHorizontalScrollBarPolicy(31);
        JScrollBar bar = scrolly.getVerticalScrollBar();
        bar.setUnitIncrement((int)(this.getPreferredSize().getHeight() / 4.0));
        bar.setFont(new Font("SansSerif", 0, 24));
        Dimension dim = new Dimension(48, 48);
        bar.setPreferredSize(dim);
        for (Component nextComp : comps = bar.getComponents()) {
            if (!(nextComp instanceof AbstractButton)) continue;
            nextComp.setPreferredSize(dim);
        }
        this.setLayout(new BorderLayout());
        this.add(scrolly);
        this.validate();
    }

    void removeItemToRender(LineRenderer toRemove) {
        if (toRemove != null) {
            this.holder.remove(toRemove.getRenderingComponent());
            this.invalidate();
        }
    }
}

