/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.views;

import au.com.ordermate.util.image.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.misc.resource.ConfigSmallImage;
import utils.ktsmate.docket.KTSDocket;

public class FooterPanel
extends JPanel {
    private KTSDocket myDocket;
    private JPanel leftPanel;
    private JPanel centrePanel;
    private JPanel rightPanel;
    private JLabel imageLabel;
    private JLabel nameLabel;
    private ConfigSmallImage customerImage;
    private static final int MAX_WIDTH = 75;
    private static final int MAX_HEIGHT = 75;
    private static final int CORNER_RADIUS = 360;

    public FooterPanel() {
        super(new BorderLayout());
        this.setupComponents();
        this.setOpaque(true);
    }

    private void setupComponents() {
        this.imageLabel = new JLabel();
        this.nameLabel = new JLabel();
        this.leftPanel = new JPanel(new BorderLayout());
        this.centrePanel = new JPanel(new BorderLayout());
        this.rightPanel = new JPanel(new BorderLayout());
        this.rightPanel.add((Component)this.imageLabel, "North");
        this.rightPanel.add((Component)this.nameLabel, "South");
        this.add((Component)this.leftPanel, "West");
        this.add((Component)this.centrePanel, "Center");
        this.add((Component)this.rightPanel, "East");
    }

    public void setDocketToRender(KTSDocket docket) {
        this.myDocket = docket;
        if (docket == null) {
            return;
        }
        this.setCustomerImage();
    }

    private void setCustomerImage() {
        if (this.myDocket.getSalesAccountDocket() != null && this.myDocket.getAccount() != null && this.myDocket.getAccount().getCustomer() != null && this.myDocket.getAccount().getCustomer().getImage() != null) {
            this.customerImage = this.myDocket.getAccount().getCustomer().getImage();
            if (this.customerImage != null) {
                Image toRender = this.resizeImage(this.customerImage.getImage());
                this.imageLabel.setIcon(new ImageIcon(toRender));
                this.nameLabel.setText(this.customerImage.getLabel());
                this.nameLabel.setHorizontalAlignment(0);
            }
        }
    }

    private Image resizeImage(Image toResize) {
        ImageHelper helper = new ImageHelper();
        Image toReturn = toResize;
        toReturn = helper.cropImageToOneOneAspectRatio(toReturn);
        toReturn = helper.fitImageTo(toReturn, 75, 75);
        toReturn = helper.roundCorners(toReturn, 360);
        return toReturn;
    }

    public String getCustomerLabelText() {
        return this.nameLabel.getText();
    }

    public Icon getDisplayedImage() {
        return this.imageLabel.getIcon();
    }

    public Image getCustomerImage() {
        return this.customerImage.getImage();
    }
}

