/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.views;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.gui.views.TabularDocketListView;

class GestureListener
extends MouseAdapter
implements MouseMotionListener {
    public final Signal gotMove = Signals.createSignal(KTSDocket.class, (String)"selectedDocket", Integer.class, (String)"index");
    public final Signal gotSelection = Signals.createSignal();
    private final int DEF_POINTS_TO_DRAG = 5;
    private KTSDocket selectedDocket = null;
    private int pointsToDrag = 5;
    private TabularDocketListView myView;

    public GestureListener(TabularDocketListView toListenTo) {
        this.myView = toListenTo;
        this.myView.addMouseListener(this);
        this.myView.addMouseMotionListener(this);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.selectedDocket != null && this.pointsToDrag > 0) {
            this.myView.gotDrag(this.selectedDocket, e.getPoint());
        } else {
            --this.pointsToDrag;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pointsToDrag = 5;
        this.selectedDocket = this.myView.getDocketAt(e.getPoint());
        if (!this.myView.isWithinDocketHeader(e.getPoint(), this.selectedDocket)) {
            this.selectedDocket = null;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        KTSDocket releasedDocket = this.myView.getDocketAt(e.getPoint());
        if (this.selectedDocket == releasedDocket) {
            boolean header;
            if (this.selectedDocket != null && (header = this.myView.isWithinDocketHeader(e.getPoint(), this.selectedDocket))) {
                this.myView.toggleDocketSelection(this.selectedDocket);
            }
            this.myView.gotFinishDrag();
            this.gotSelection.emit();
            return;
        }
        if (this.selectedDocket != null) {
            int index = this.myView.getIndexForPoint(e.getPoint());
            if (index != -1) {
                this.gotMove.emit((Object)this.selectedDocket, (Object)index);
            }
            this.myView.deselectDockets();
        }
        this.myView.gotFinishDrag();
        this.gotSelection.emit();
        this.selectedDocket = null;
    }
}

