/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.views;

import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.text.View;
import ordermate.OrderMate;
import ordermate.database.gui.FontAttributes;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.hardware.physical.kts.KTSShowTime;
import ordermate.database.sales.Account;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSDocketEvent;
import utils.ktsmate.gui.KTSUIHelper;

public class HeaderPanel
extends JPanel {
    private static final Color NORMAL = Color.GRAY.brighter();
    private static final Color RUSHED = Color.ORANGE;
    private static final Color SELECTED = Color.GREEN.brighter();
    private static final Font TIMER_FONT = new Font("Courier", 0, 14);
    private static final Map<TextAttribute, Object> boldMap = new HashMap<TextAttribute, Object>();
    private JPanel rightPanel;
    private JPanel infoPanel;
    private JLabel timerLabel;
    private JLabel holdTimerLabel;
    private JLabel initialTimerLabel;
    private JLabel accLabel;
    private JLabel orderLabel;
    private JLabel accountLabel;
    private JLabel userLabel;
    private JLabel customerLabel;
    private JLabel addressStreetLabel;
    private JLabel addressSuburbLabel;
    private JLabel ticketDataLabel;
    private JLabel dueLabel;
    private JLabel etaLabel;
    private JLabel extOrderIdLabel;
    private JLabel extOrderAltIdLabel;
    private KTSDocket myDocket;
    private Color background = NORMAL;
    private KTSShowTime showTime;

    public HeaderPanel() {
        super(new BorderLayout());
        this.setupComponents();
        this.setOpaque(true);
        this.setBorder(new EtchedBorder(1));
    }

    protected JPanel getRightPanel() {
        return this.rightPanel;
    }

    protected void setupComponents() {
        this.setBackground(NORMAL);
        this.setOpaque(true);
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new BorderLayout());
        JPanel timerPanel = new JPanel();
        timerPanel.setLayout(new BoxLayout(timerPanel, 1));
        this.timerLabel = new JLabel("");
        this.timerLabel.setHorizontalAlignment(4);
        this.timerLabel.setAlignmentX(1.0f);
        this.timerLabel.setOpaque(false);
        this.timerLabel.setFont(TIMER_FONT);
        this.holdTimerLabel = new JLabel("", IconLoader.get((String)"/utils/ktsmate/images/holdSmall.png"), 4);
        this.holdTimerLabel.setHorizontalAlignment(4);
        this.holdTimerLabel.setAlignmentX(1.0f);
        this.holdTimerLabel.setOpaque(false);
        this.holdTimerLabel.setFont(TIMER_FONT);
        this.initialTimerLabel = new JLabel("", IconLoader.get((String)"/utils/ktsmate/images/timerSmall.png"), 4);
        this.initialTimerLabel.setHorizontalAlignment(4);
        this.initialTimerLabel.setAlignmentX(1.0f);
        this.initialTimerLabel.setOpaque(false);
        this.initialTimerLabel.setFont(TIMER_FONT);
        timerPanel.add(this.timerLabel);
        timerPanel.add(this.holdTimerLabel);
        timerPanel.add(this.initialTimerLabel);
        timerPanel.setOpaque(false);
        this.rightPanel.add((Component)timerPanel, "North");
        this.rightPanel.setOpaque(false);
        this.add((Component)this.rightPanel, "East");
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(new BoxLayout(this.infoPanel, 1));
        this.accLabel = new JLabel("");
        this.infoPanel.add(this.accLabel);
        this.orderLabel = new JLabel("");
        this.infoPanel.add(this.orderLabel);
        this.accountLabel = new JLabel("Account:");
        this.infoPanel.add(this.accountLabel);
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        FontAttributes attributes = printer.getHeaderAttributes();
        this.showTime = printer.getShowTime();
        this.userLabel = new JLabel("<html><b>User:</b></html>");
        this.infoPanel.add(this.userLabel);
        this.extOrderIdLabel = new JLabel("");
        this.infoPanel.add(this.extOrderIdLabel);
        this.extOrderAltIdLabel = new JLabel("");
        this.infoPanel.add(this.extOrderAltIdLabel);
        Font font = null;
        if (attributes != null) {
            font = printer.getHeaderAttributes().generateFont();
            this.accountLabel.setFont(font.deriveFont(1));
            this.orderLabel.setFont(font.deriveFont(1));
            this.accLabel.setFont(font.deriveFont(1));
            this.extOrderIdLabel.setFont(font.deriveFont(1));
            this.extOrderAltIdLabel.setFont(font.deriveFont(1));
        } else {
            OrderMate.LOG.warn("null Font Attributes for Header, check the database!");
        }
        this.userLabel.setFont(font);
        this.ticketDataLabel = new JLabel("<html><b>Stand:</b></html>");
        this.infoPanel.add(this.ticketDataLabel);
        this.customerLabel = new JLabel("<html><b>Cust:</b></html>");
        this.infoPanel.add(this.customerLabel);
        this.customerLabel.setFont(font);
        this.dueLabel = new JLabel("Due:");
        this.dueLabel.setFont(font);
        this.infoPanel.add(this.dueLabel);
        this.etaLabel = new JLabel();
        this.etaLabel.setFont(font);
        this.infoPanel.add(this.etaLabel);
        this.addressStreetLabel = new JLabel("");
        this.addressStreetLabel.setFont(font);
        this.infoPanel.add(this.addressStreetLabel);
        this.addressSuburbLabel = new JLabel("");
        this.addressSuburbLabel.setFont(font);
        this.infoPanel.add(this.addressSuburbLabel);
        if (font != null) {
            this.ticketDataLabel.setFont(font.deriveFont(boldMap));
        }
        this.infoPanel.setOpaque(false);
        this.add((Component)this.infoPanel, "Center");
    }

    public synchronized void setDocketToRender(KTSDocket docket) {
        this.myDocket = docket;
        if (docket == null) {
            return;
        }
        this.background = docket.isRushed() ? RUSHED : NORMAL;
        this.setBackground(this.background);
        this.updateAccountNumber();
        this.updateOrderNumber();
        this.updateAccount();
        this.updateUser();
        this.updateExtOrderId();
        this.updateAlternateId();
        this.updateCustomer();
        this.updateTicketData();
        this.updateDueData();
        this.updateETAOnDocket();
        this.gotUpdatePanel();
    }

    private void updateOrderNumber() {
        Account account = this.myDocket.getTargetAccount();
        if (account == null) {
            account = this.myDocket.getAccount();
        }
        KTSUIHelper.getInstance().applyOrderNumber(this.orderLabel, account);
    }

    private void updateExtOrderId() {
        Account account = this.myDocket.getTargetAccount();
        if (account == null) {
            account = this.myDocket.getAccount();
        }
        KTSUIHelper.getInstance().applyOrderExtId(this.extOrderIdLabel, account);
    }

    private void updateAlternateId() {
        Account account = this.myDocket.getTargetAccount();
        if (account == null) {
            account = this.myDocket.getAccount();
        }
        KTSUIHelper.getInstance().applyOrderAlternateId(this.extOrderAltIdLabel, account);
    }

    private void updateAccountNumber() {
        Account account = this.myDocket.getTargetAccount();
        if (account == null) {
            account = this.myDocket.getAccount();
        }
        KTSUIHelper.getInstance().applyAccountNumber(this.accLabel, account);
    }

    private void updateETAOnDocket() {
        Account account = this.myDocket.getAccount();
        KTSUIHelper.getInstance().applyETA(this.etaLabel, account);
    }

    private void updateAccount() {
        Account account = this.myDocket.getTargetAccount();
        if (account == null) {
            account = this.myDocket.getAccount();
        }
        KTSUIHelper.getInstance().applyAccountName(this.accountLabel, account);
    }

    private void updateUser() {
        KTSUIHelper.getInstance().applyUserName(this.userLabel, this.myDocket);
    }

    private void updateCustomer() {
        Account account = this.myDocket.getAccount();
        KTSUIHelper.getInstance().applyCustomer(this.customerLabel, this.addressStreetLabel, this.addressSuburbLabel, account);
    }

    private void updateTicketData() {
        Account account = this.myDocket.getAccount();
        KTSUIHelper.getInstance().applyTicketData(this.ticketDataLabel, account);
    }

    private void updateDueData() {
        Account account = this.myDocket.getAccount();
        KTSUIHelper.getInstance().applyDueTime(this.dueLabel, account);
    }

    protected final KTSDocket getDocketToRender() {
        return this.myDocket;
    }

    public synchronized void gotUpdatePanel() {
        String initialString;
        if (this.myDocket == null) {
            return;
        }
        KTSDocketEvent lastEvent = this.myDocket.getLastEvent();
        if (lastEvent == null) {
            return;
        }
        long time = this.myDocket.getNonBumpedTime();
        long initialTime = this.myDocket.getInitialTime();
        long holdTime = this.myDocket.getHoldTime();
        if (!KTSDocketState.Bump.equals((Object)this.myDocket.getDocketState())) {
            long offset = System.currentTimeMillis() - lastEvent.getTime();
            time = offset + time;
            if (KTSDocketState.Hold.equals((Object)this.myDocket.getDocketState())) {
                holdTime = offset + holdTime;
            }
        }
        time /= 1000L;
        holdTime /= 1000L;
        initialTime /= 1000L;
        if (KTSShowTime.Separated.equals((Object)this.showTime)) {
            initialTime += time;
        } else if (KTSShowTime.Combined.equals((Object)this.showTime)) {
            time += initialTime;
            initialTime = 0L;
        } else {
            initialTime = 0L;
        }
        final String timeString = KTSUIHelper.makeTimeString(time);
        final String holdString = holdTime == 0L ? null : KTSUIHelper.makeTimeString(holdTime);
        String string = initialString = initialTime == 0L ? null : KTSUIHelper.makeTimeString(initialTime);
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HeaderPanel.this.updateTimeStrings(timeString, holdString, initialString);
                }
            });
        } else {
            this.updateTimeStrings(timeString, holdString, initialString);
        }
    }

    private void updateTimeStrings(String timeText, String holdTimeText, String initialTime) {
        this.timerLabel.setText(timeText);
        if (holdTimeText != null) {
            this.holdTimerLabel.setVisible(true);
            this.holdTimerLabel.setText(holdTimeText);
        } else {
            this.holdTimerLabel.setVisible(false);
        }
        if (initialTime != null) {
            this.initialTimerLabel.setText(initialTime);
            this.initialTimerLabel.setVisible(true);
        } else {
            this.initialTimerLabel.setVisible(false);
        }
    }

    void setSelected(boolean value) {
        if (value) {
            this.setBackground(SELECTED);
        } else {
            this.setBackground(this.background);
        }
    }

    protected JLabel getTimerLabel() {
        return this.timerLabel;
    }

    protected JLabel getTicketDataLabel() {
        return this.ticketDataLabel;
    }

    protected JLabel getHoldTimerLabel() {
        return this.holdTimerLabel;
    }

    protected JLabel getInitialTimerLabel() {
        return this.initialTimerLabel;
    }

    protected String getTimeDueLabel() {
        return this.dueLabel.getText();
    }

    protected String getETALabelText() {
        return this.etaLabel.getText();
    }

    protected String getAccountLabel() {
        return this.accountLabel.getText();
    }

    protected String getAccNumLabel() {
        return this.accLabel.getText();
    }

    protected String getOrderNumberLabel() {
        return this.orderLabel.getText();
    }

    protected String getExtOrderIdLabel() {
        return this.extOrderIdLabel.getText();
    }

    protected String getAltOrderIdLabel() {
        return this.extOrderAltIdLabel.getText();
    }

    protected String getCustomerLabel() {
        return this.customerLabel.getText();
    }

    protected String getUserLabelText() {
        return this.userLabel.getText();
    }

    protected String getAddressStreetLabel() {
        return this.addressStreetLabel.getText();
    }

    protected String getAddressSuburbLabel() {
        return this.addressSuburbLabel.getText();
    }

    public int getExpectedHeight(int width) {
        int FILTHY_PADDING = 6;
        this.rightPanel.validate();
        this.validate();
        int reduced = width - this.rightPanel.getWidth() - FILTHY_PADDING;
        int tally = 0;
        for (Component comp : this.infoPanel.getComponents()) {
            if (!(comp instanceof JLabel)) continue;
            tally += this.getExpectedHeight((JLabel)comp, reduced);
        }
        return tally += FILTHY_PADDING;
    }

    public int getExpectedHeight(JLabel label, int width) {
        if (!label.isVisible() || StringUtils.isEmpty((String)label.getText())) {
            return 0;
        }
        View view = (View)label.getClientProperty("html");
        if (view != null) {
            view.setSize(width, 0.0f);
            float h = view.getPreferredSpan(1);
            return (int)Math.ceil(h);
        }
        return label.getHeight();
    }

    static {
        boldMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
    }
}

