/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.views;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import ordermate.database.hardware.physical.kts.KTSCommand;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.misc.SystemProperty;
import utils.ktsmate.KTSMate;
import utils.ktsmate.KTSNavBar;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSListController;
import utils.ktsmate.gui.views.AbstractDocketListView;
import utils.ktsmate.gui.views.DefaultDocketPanelFactory;
import utils.ktsmate.gui.views.TabularDocketListView;
import waitermate.guikit.ScreenResource;

public class HoldView
extends AbstractDocketListView {
    private static final double DIALOG_FACTOR = 0.8;

    public HoldView(KTSListController controller) {
        super(controller);
    }

    @Override
    protected TabularDocketListView createListView() {
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        Dimension frameSize = ScreenResource.getTarget().getSize();
        Dimension dialogSize = new Dimension((int)frameSize.getWidth(), (int)(frameSize.getHeight() * 0.8));
        return new TabularDocketListView(new DefaultDocketPanelFactory(), printer.getNumRows(), printer.getNumColumns(), printer.getAnimTime(), dialogSize);
    }

    @Override
    protected KTSNavBar createNavBar() {
        return new HoldNavBar();
    }

    @Override
    public KTSDocketState getViewState() {
        return KTSDocketState.Hold;
    }

    private int getChangeStateMoveToPosition() {
        int position = 0;
        if (SystemProperty.getInstance().isKtsUnholdToEndOfQueue()) {
            position = Integer.MAX_VALUE;
        }
        return position;
    }

    public void gotUnhold() {
        final List<KTSDocket> toRevive = this.getSelectedDockets();
        final int position = this.getChangeStateMoveToPosition();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (KTSDocket nextDocket : toRevive) {
                    HoldView.this.listController.changeDocketState(nextDocket, KTSDocketState.Live, position);
                }
            }
        });
    }

    @Override
    public void gotDocketSelected() {
        super.gotDocketSelected();
        ((HoldNavBar)this.getNavBar()).unholdButton.setEnabled(!this.getView().getSelectedDockets().isEmpty());
    }

    @Override
    public boolean doCommand(KTSCommand command) {
        boolean handled = super.doCommand(command);
        if (!handled) {
            if (KTSCommand.Ok.equals((Object)command)) {
                handled = true;
                this.getNavBar().ok.emit();
            } else if (KTSCommand.Cancel.equals((Object)command)) {
                handled = true;
                this.getNavBar().back.emit();
            }
        }
        return handled;
    }

    @Override
    public void gotDocketActioned(KTSDocket docket) {
        this.getView().deselectDockets();
        this.getView().toggleDocketSelection(docket);
        this.gotUnhold();
    }

    private class HoldNavBar
    extends KTSNavBar {
        private JButton backButton;
        private JButton unholdButton;

        private HoldNavBar() {
        }

        @Override
        protected void setupNav() {
            super.setupNav();
            this.backButton = this.constructButton((Icon)IconLoader.get((String)"/utils/ktsmate/images/back.png"), "Cancel", "backButton", this.back);
            this.unholdButton = this.constructButton((Icon)IconLoader.get((String)"/utils/ktsmate/images/ok.png"), "OK", "unholdButton", this.ok);
            this.unholdButton.setEnabled(false);
            this.ok.disconnectAll();
            this.ok.connect((Object)HoldView.this, "gotUnhold");
            this.addLeft(this.backButton, 0);
            this.addRight(this.unholdButton);
            this.setText("<html>Tap the header of an <b>On-Hold</b> docket<br>and hit OK to revive</html>");
        }
    }
}

