/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.views;

import java.util.List;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.kts.KTSCommand;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.gui.views.TabularDocketListView;

class TabularDocketListCommand {
    private TabularDocketListView listView;

    public TabularDocketListCommand(TabularDocketListView view) {
        this.listView = view;
    }

    public boolean doCommand(KTSCommand command) {
        boolean handled = false;
        if (command.name().startsWith("Docket")) {
            handled = true;
            this.docketPressed(command.name().substring("Docket".length()));
        } else if (KTSCommand.Left.equals((Object)command)) {
            handled = true;
            this.selectNext(false);
        } else if (KTSCommand.Right.equals((Object)command)) {
            handled = true;
            this.selectNext(true);
        } else if (KTSCommand.Up.equals((Object)command)) {
            handled = true;
            this.selectDown(false);
        } else if (KTSCommand.Down.equals((Object)command)) {
            handled = true;
            this.selectDown(true);
        } else if (KTSCommand.Cancel.equals((Object)command)) {
            handled = this.listView.cancel();
        }
        return handled;
    }

    private void docketPressed(String docketNumber) {
        Integer index = 0;
        try {
            index = Integer.parseInt(docketNumber);
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.error("Cannot parse docketNumber:" + docketNumber);
        }
        if (index > 0) {
            OrderMate.LOG.info("Docket Selected:" + index);
            KTSDocket view = this.listView.getDocketForRelativeIndex(index - 1);
            if (view != null) {
                this.listView.fireDocketAction(view);
            }
        }
    }

    private KTSDocket getCurrentDocket() {
        KTSDocket currentDocket = null;
        List<KTSDocket> selections = this.listView.getSelectedDockets();
        if (!selections.isEmpty()) {
            currentDocket = selections.get(0);
        }
        return currentDocket;
    }

    private void selectNext(boolean forward) {
        KTSDocket currentDocket = this.getCurrentDocket();
        if (currentDocket == null) {
            currentDocket = this.listView.getDocketForIndex(0);
        } else {
            int index = this.listView.indexOf(currentDocket);
            index = forward ? ++index : --index;
            currentDocket = this.listView.getDocketForIndex(index);
        }
        if (currentDocket != null) {
            this.listView.deselectDockets();
            this.listView.gotDocketSelected(currentDocket);
        }
    }

    private void selectDown(boolean down) {
        KTSDocket currentDocket = this.getCurrentDocket();
        if (currentDocket != null) {
            this.listView.selectNextRow(down);
        }
    }
}

