/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.views;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.kts.KTSCommand;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.transitions.ScreenTransition;
import org.jdesktop.animation.transitions.TransitionTarget;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.gui.DragPainter;
import utils.ktsmate.gui.views.DocketPanelFactory;
import utils.ktsmate.gui.views.TabularDocketListCommand;
import utils.ktsmate.gui.views.TabularDocketView;

public class TabularDocketListView
extends JPanel
implements ListEventListener<KTSDocket>,
TransitionTarget {
    public final Signal listUpdated = Signals.createSignal();
    public final Signal docketActioned = Signals.createSignal(KTSDocket.class, (String)"theDocket");
    private final int PADDING = 2;
    private int rows;
    private int columns;
    private Dimension mainPanelSize;
    private EventList<KTSDocket> docketList;
    private DocketPanelFactory panelFactory;
    private final List<KTSDocket> selectedDockets = new ArrayList<KTSDocket>();
    private AtomicInteger indexFirstShowing = new AtomicInteger();
    private AtomicInteger indexLastShowing = new AtomicInteger();
    private Animator animator;
    private ScreenTransition transition;
    private Timer refreshTimer;
    private KTSDocketState myState;
    private final DragPainter ghostPainter;
    private Image logo;
    private Image softLogo;
    private TabularDocketListCommand commandHandler;
    private boolean backgroundLogo = false;
    private final Map<KTSDocket, TabularDocketView> viewMap = new ConcurrentHashMap<KTSDocket, TabularDocketView>();

    public TabularDocketListView(DocketPanelFactory thePanelFactory, int numRows, int numCols, int animTime, Dimension mainSize) {
        this.panelFactory = thePanelFactory;
        if (this.panelFactory == null) {
            throw new IllegalArgumentException("Cannot initialise a TabularDockeListView with a null panel factory");
        }
        if (mainSize != null) {
            this.mainPanelSize = new Dimension(mainSize);
        }
        this.rows = numRows;
        this.columns = numCols;
        this.createMainPanel();
        if (animTime > 0) {
            this.animator = new Animator(animTime);
            this.transition = new ScreenTransition((JComponent)this, (TransitionTarget)this, this.animator);
        }
        this.ghostPainter = new DragPainter(this);
        this.commandHandler = this.createCommandHandler();
        this.backgroundLogo = !Config.getBooleanValue((String)"nologo");
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.docketList.size() == 0 && this.logo != null) {
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.backgroundLogo) {
                g2.drawImage(this.logo, this.getWidth() - this.logo.getWidth(null) - this.getWidth() / 20, this.getHeight() / 2 - this.logo.getHeight(null) / 2, null);
            }
        } else {
            g2.setColor(Color.DARK_GRAY);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.backgroundLogo && this.softLogo != null) {
                g2.drawImage(this.softLogo, this.getWidth() - this.softLogo.getWidth(null) - this.getWidth() / 20, this.getHeight() / 2 - this.softLogo.getHeight(null) / 2, null);
            }
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.ghostPainter.paint(g);
    }

    private void resampleLogo() {
        if (KTSDocketState.Live.equals((Object)this.myState) && (this.logo == null || Math.abs(this.mainPanelSize.width - this.logo.getWidth(null) * 2) > 4 && Math.abs(this.mainPanelSize.height - this.logo.getHeight(null) * 2) > 4)) {
            OrderMateLog.LOG.info("Resampling background image");
            ImageIcon originalGraphic = IconLoader.get((String)"/ordermate/images/logo_2024_transparent.png");
            double scaleW = (double)(this.getWidth() / 2) / (double)originalGraphic.getIconWidth();
            double scaleH = (double)(this.getHeight() / 2) / (double)originalGraphic.getIconHeight();
            double scaleToUse = Math.min(scaleW, scaleH);
            ImageHelper imageHelper = new ImageHelper();
            if (scaleToUse > 0.0) {
                this.logo = imageHelper.rescaleImage(originalGraphic.getImage(), scaleToUse);
            }
            this.softLogo = imageHelper.tintImage(this.logo, Color.BLACK, 0.5f);
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
        this.refreshView();
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
        this.refreshView();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        boolean resample = this.getWidth() != width || this.getHeight() != height;
        super.setBounds(x, y, width, height);
        if (resample && this.backgroundLogo) {
            this.logo = null;
            this.softLogo = null;
            this.resampleLogo();
        }
    }

    public void setDocketList(EventList<KTSDocket> newDocketList, KTSDocketState yourState) {
        if (newDocketList == this.docketList) {
            return;
        }
        this.myState = yourState;
        if (this.refreshTimer != null) {
            OrderMate.LOG.warn("Header refresh Timer has been cancelled");
            this.refreshTimer.cancel();
            this.refreshTimer = null;
        }
        if (this.docketList != null) {
            this.docketList.removeListEventListener((ListEventListener)this);
        }
        for (TabularDocketView view : this.viewMap.values()) {
            view.dropEverything();
            view = null;
        }
        this.viewMap.clear();
        this.docketList = newDocketList;
        if (this.docketList != null) {
            this.docketList.addListEventListener((ListEventListener)this);
            this.updateList();
            this.refreshTimer = new Timer();
            this.refreshTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        HashSet keys = new HashSet(TabularDocketListView.this.viewMap.keySet());
                        for (KTSDocket nextDocket : keys) {
                            TabularDocketView nextView = (TabularDocketView)TabularDocketListView.this.viewMap.get(nextDocket);
                            if (nextView != null) {
                                if (!nextView.isDisplayable()) continue;
                                try {
                                    nextView.updateHeader();
                                }
                                catch (Throwable ex) {
                                    OrderMate.LOG.error("Could not update header!", ex);
                                }
                                continue;
                            }
                            OrderMate.LOG.warn("Strange, no docket found in the tabular docket view");
                        }
                    }
                    catch (Throwable ex) {
                        OrderMate.LOG.error("Explosion while updating the header!", ex);
                    }
                }
            }, 1000L, 1000L);
            OrderMate.LOG.info("Header Refresh Timer reinstated");
        }
    }

    private void createMainPanel() {
        this.setLayout(new FlowLayout(0, 2, 2));
        this.setPreferredSize(this.mainPanelSize);
        this.setMinimumSize(this.mainPanelSize);
        if (this.mainPanelSize == null) {
            this.mainPanelSize = new Dimension(this.getSize());
        }
        this.setOpaque(true);
        this.setBackground(Color.BLACK);
    }

    private TabularDocketView getDocketView(KTSDocket docket) {
        if (this.viewMap.containsKey(docket)) {
            return this.viewMap.get(docket);
        }
        OrderMateLog.LOG.info("Creating new docket view");
        Dimension commonDim = this.getCommonViewDimension();
        TabularDocketView newView = new TabularDocketView(this.panelFactory, commonDim, this.columns, docket);
        this.viewMap.put(docket, newView);
        return this.viewMap.get(docket);
    }

    TabularDocketView getDocketViewIfExists(KTSDocket docket) {
        return this.viewMap.get(docket);
    }

    private void adjustDocketSizes() {
        if (this.mainPanelSize.equals(this.getSize())) {
            OrderMate.LOG.debug("No size to adjust in adjust docket sizes");
            return;
        }
        OrderMate.LOG.debug("Adjusting sizes for dockets, mainPanelSize is different to current size");
        Dimension commonDim = this.getCommonViewDimension();
        for (TabularDocketView nextView : this.viewMap.values()) {
            nextView.setDiscreteDimension(commonDim);
        }
    }

    private Dimension getCommonViewDimension() {
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            this.mainPanelSize = new Dimension(this.getSize());
        }
        int availableWidth = this.mainPanelSize.width - (1 + this.columns) * 2;
        int availableHeight = this.mainPanelSize.height - (1 + this.rows) * 2;
        return new Dimension(availableWidth / this.columns, availableHeight / this.rows);
    }

    public void gotDocketSelected(KTSDocket docket) {
        if (this.selectedDockets.contains(docket)) {
            this.selectedDockets.remove(docket);
        } else {
            this.selectedDockets.add(docket);
            Integer relativePage = this.getRelativePageFor(docket);
            if (relativePage != null) {
                if (relativePage < 0) {
                    this.switchPage(false);
                } else if (relativePage > 0) {
                    this.switchPage(true);
                }
            }
        }
        this.updateSelections();
    }

    public void updateSelections() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (KTSDocket nextDocket : TabularDocketListView.this.viewMap.keySet()) {
                    ((TabularDocketView)TabularDocketListView.this.viewMap.get(nextDocket)).setSelected(TabularDocketListView.this.selectedDockets.contains(nextDocket));
                }
            }
        });
    }

    void updateList() {
        OrderMate.LOG.info("Updating tabular docket list");
        HashSet<KTSDocket> docketSet = new HashSet<KTSDocket>(this.viewMap.keySet());
        for (KTSDocket nextDocket : docketSet) {
            if (nextDocket.getDocketState().equals((Object)this.myState)) continue;
            OrderMateLog.LOG.info("Dropping Renderer for docket.");
            this.selectedDockets.remove(nextDocket);
            TabularDocketView docketView = this.viewMap.get(nextDocket);
            docketView.dropEverything();
            docketView.invalidate();
            docketView = null;
            this.viewMap.remove(nextDocket);
        }
        if (this.transition != null && this.isShowing()) {
            if (!this.transition.getAnimator().isRunning()) {
                this.transition.start();
            } else {
                OrderMate.LOG.info("Cancelling animation");
                this.transition.getAnimator().cancel();
                this.setupNextScreen();
                this.validate();
                this.repaint();
                this.updateList();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TabularDocketListView.this.setupNextScreen();
                    TabularDocketListView.this.validate();
                    TabularDocketListView.this.repaint();
                }
            });
        }
    }

    public void setupNextScreen() {
        if (this.docketList == null) {
            return;
        }
        this.adjustDocketSizes();
        this.resampleLogo();
        this.docketList.getReadWriteLock().writeLock().lock();
        try {
            int numDockets = this.docketList.size();
            if (numDockets > 0 && this.indexFirstShowing.get() >= numDockets) {
                this.indexFirstShowing.set(-1);
            }
            if (this.docketList.size() >= 0) {
                if (this.indexFirstShowing.get() >= 0) {
                    this.layoutForwards();
                } else {
                    this.layoutBackwards();
                    if (this.indexFirstShowing.get() == 0) {
                        this.layoutForwards();
                    }
                }
            }
            this.selectedDockets.retainAll((Collection<?>)this.docketList);
        }
        finally {
            this.docketList.getReadWriteLock().writeLock().unlock();
        }
        this.revalidate();
        this.listUpdated.emit();
    }

    private void layoutForwards() {
        int maxIdxFirstShowing = Math.max(this.indexFirstShowing.get(), 0);
        this.indexFirstShowing.set(maxIdxFirstShowing);
        this.removeAll();
        for (int i = this.indexFirstShowing.get(); i < this.docketList.size(); ++i) {
            KTSDocket nextDocket = (KTSDocket)this.docketList.get(i);
            TabularDocketView view = this.getDocketView(nextDocket);
            this.add(view);
            this.updateDocketView(view);
            this.validate();
            if (view.getY() + view.getHeight() > this.getHeight()) {
                this.remove(view);
                this.validate();
                break;
            }
            this.indexLastShowing.set(i);
        }
    }

    private void layoutBackwards() {
        int maxIdxLastShowing = Math.max(Math.min(this.indexLastShowing.get(), this.getNumDockets() - 1), 0);
        this.indexLastShowing.set(maxIdxLastShowing);
        TabularDocketView lastView = this.getDocketView((KTSDocket)this.docketList.get(this.indexLastShowing.get()));
        this.removeAll();
        for (int i = this.indexLastShowing.get(); i >= 0; --i) {
            KTSDocket nextDocket = (KTSDocket)this.docketList.get(i);
            TabularDocketView view = this.getDocketView(nextDocket);
            this.add((Component)view, 0);
            this.updateDocketView(view);
            this.validate();
            if (lastView.getY() + lastView.getHeight() > this.getHeight()) {
                this.remove(view);
                this.validate();
                break;
            }
            this.indexFirstShowing.set(i);
            this.indexLastShowing.set(this.indexFirstShowing.get() + this.getComponentCount() - 1);
        }
    }

    public void listChanged(ListEvent<KTSDocket> arg0) {
        this.refreshView();
    }

    private void refreshView() {
        this.updateList();
        this.updateSelections();
    }

    public List<KTSDocket> getSelectedDockets() {
        return Collections.unmodifiableList(this.selectedDockets);
    }

    public int getLastDocketIndex() {
        return this.indexLastShowing.get();
    }

    public int getFirstDocketIndex() {
        return this.indexFirstShowing.get();
    }

    public void setFirstDocketIndex(int value) {
        this.indexFirstShowing.set(Math.max(value, 0));
        this.indexLastShowing.set(this.indexFirstShowing.get());
        this.refreshView();
    }

    public void setLastDocketIndex(int value) {
        this.indexLastShowing.set(Math.max(value, 1));
        this.indexFirstShowing.set(-1);
        this.refreshView();
    }

    public int getNumDockets() {
        this.docketList.getReadWriteLock().writeLock().lock();
        int size = this.docketList.size();
        this.docketList.getReadWriteLock().writeLock().unlock();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KTSDocket getDocketAt(Point point) {
        this.docketList.getReadWriteLock().writeLock().lock();
        try {
            if (!this.contains(point) || this.docketList.size() == 0) {
                KTSDocket kTSDocket = null;
                return kTSDocket;
            }
            int first = Math.max(0, this.getFirstDocketIndex());
            int last = Math.min(this.docketList.size() - 1, this.getLastDocketIndex());
            for (int i = first; i <= last; ++i) {
                KTSDocket docket;
                TabularDocketView view = this.viewMap.get(this.docketList.get(i));
                if (!view.getBounds().contains(point)) continue;
                KTSDocket kTSDocket = docket = (KTSDocket)this.docketList.get(i);
                return kTSDocket;
            }
            KTSDocket kTSDocket = null;
            return kTSDocket;
        }
        finally {
            this.docketList.getReadWriteLock().writeLock().unlock();
        }
    }

    public boolean isWithinDocketHeader(Point point, KTSDocket docket) {
        if (docket == null) {
            return false;
        }
        TabularDocketView view = this.viewMap.get(docket);
        if (view != null) {
            Rectangle bounds = view.getBounds();
            return view.headerContains(new Point(point.x - bounds.x, point.y - bounds.y));
        }
        return false;
    }

    public void toggleDocketSelection(KTSDocket docket) {
        TabularDocketView view = this.viewMap.get(docket);
        if (view != null) {
            this.gotDocketSelected(docket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexForPoint(Point point) {
        if (!this.contains(point)) {
            return -1;
        }
        int lastGoodIndex = -1;
        this.docketList.getReadWriteLock().writeLock().lock();
        try {
            int first = Math.max(0, this.getFirstDocketIndex());
            int last = Math.min(this.docketList.size() - 1, this.getLastDocketIndex());
            for (int i = first; i <= last; ++i) {
                TabularDocketView view = this.viewMap.get(this.docketList.get(i));
                Rectangle bounds = view.getBounds();
                if (bounds.contains(point)) {
                    int n = i;
                    return n;
                }
                if (bounds.y > point.y || bounds.y + bounds.height < point.y) continue;
                lastGoodIndex = i + 1;
            }
            int n = lastGoodIndex;
            return n;
        }
        finally {
            this.docketList.getReadWriteLock().writeLock().unlock();
        }
    }

    public void deselectDockets() {
        this.cancel();
        this.selectedDockets.clear();
        this.updateSelections();
    }

    public Integer getRelativePageFor(KTSDocket docket) {
        this.docketList.getReadWriteLock().writeLock().lock();
        int index = this.docketList.indexOf((Object)docket);
        this.docketList.getReadWriteLock().writeLock().unlock();
        if (index < 0) {
            return null;
        }
        if (index < this.indexFirstShowing.get()) {
            return -1;
        }
        if (index > this.indexLastShowing.get()) {
            return 1;
        }
        return 0;
    }

    void gotDrag(KTSDocket docket, Point point) {
        this.ghostPainter.dragComponent(this.viewMap.get(docket), point);
    }

    void gotFinishDrag() {
        this.ghostPainter.dragComponent(null, null);
    }

    public boolean doCommand(KTSCommand command) {
        return this.commandHandler.doCommand(command);
    }

    protected TabularDocketListCommand createCommandHandler() {
        return new TabularDocketListCommand(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KTSDocket getDocketForRelativeIndex(int index) {
        TabularDocketListView tabularDocketListView = this;
        synchronized (tabularDocketListView) {
            int relativeIndex = index + this.getFirstDocketIndex();
            return this.getDocketForIndex(relativeIndex);
        }
    }

    public KTSDocket getDocketForIndex(int index) {
        KTSDocket docket = null;
        this.docketList.getReadWriteLock().writeLock().lock();
        if (index >= 0 && index < this.docketList.size()) {
            docket = (KTSDocket)this.docketList.get(index);
        }
        this.docketList.getReadWriteLock().writeLock().unlock();
        return docket;
    }

    public int indexOf(KTSDocket currentDocket) {
        int index = -1;
        this.docketList.getReadWriteLock().writeLock().lock();
        index = this.docketList.indexOf((Object)currentDocket);
        this.docketList.getReadWriteLock().writeLock().unlock();
        return index;
    }

    void fireDocketAction(KTSDocket renderedDocket) {
        this.docketActioned.emit((Object)renderedDocket);
    }

    public void switchPage(boolean forward) {
        this.cancel();
        if (forward) {
            int lastDocket = this.getLastDocketIndex();
            if (lastDocket < this.getNumDockets() - 1) {
                this.setFirstDocketIndex(lastDocket + 1);
            }
        } else {
            int firstDocket = this.getFirstDocketIndex();
            if (firstDocket > 0) {
                this.setLastDocketIndex(firstDocket - 1);
            }
        }
    }

    public void stopAnimations() {
        if (this.transition != null && this.transition.getAnimator().isRunning()) {
            try {
                this.transition.getAnimator().stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public KTSDocket getSelectedDocket() {
        if (this.selectedDockets.isEmpty()) {
            return null;
        }
        return this.selectedDockets.get(0);
    }

    public void selectNextRow(boolean down) {
        KTSDocket docket = this.getSelectedDocket();
        if (docket != null) {
            docket.selectNextLine(down);
            this.updateDocketView(this.viewMap.get(docket));
        }
    }

    public boolean cancel() {
        KTSDocket docket = this.getSelectedDocket();
        if (docket != null && docket.getSelectedLine() != null) {
            docket.deselectLine();
            this.updateDocketView(this.viewMap.get(docket));
            return true;
        }
        return false;
    }

    private void updateDocketView(TabularDocketView view) {
        try {
            view.updateRenderer();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Docket Renderer broken", (Throwable)ex);
        }
    }
}

