/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.views;

import au.com.ordermate.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.misc.Course;
import ordermate.database.sales.Account;
import ordermate.database.sales.TableAccount;
import ordermate.gui.DecoratorLocation;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.docket.line.KTSStringLine;
import utils.ktsmate.docket.line.SummaryLine;
import utils.ktsmate.docket.line.notifier.KTSNotifyPrinterLine;
import utils.ktsmate.gui.renderer.LineRenderer;
import utils.ktsmate.gui.views.DocketItemsPanel;
import utils.ktsmate.gui.views.DocketPanelFactory;
import utils.ktsmate.gui.views.FooterPanel;
import utils.ktsmate.gui.views.HeaderPanel;

class TabularDocketView
extends JPanel {
    private static final int PADDING = 2;
    private Dimension discreteSize;
    private int maxShownPanels = 4;
    private Long lastModCount = 0L;
    private KTSDocket docketToRender;
    private List<JComponent> displayablePanels;
    private List<LineRenderer> renderers;
    private HeaderPanel header;
    private FooterPanel footer;
    private DocketPanelFactory panelFactory;
    private static final Color LIGHT_RED = new Color(255, 200, 210);
    private static final Color LIGHT_BLUE = new Color(200, 210, 255);

    public TabularDocketView(DocketPanelFactory thePanelFactory, Dimension discreteDimension, int maxPanels, KTSDocket toRender) {
        this.setOpaque(true);
        this.setLayout(new BoxLayout(this, 0));
        this.panelFactory = thePanelFactory;
        this.displayablePanels = new ArrayList<JComponent>();
        this.renderers = new ArrayList<LineRenderer>();
        this.setDiscreteDimension(discreteDimension);
        this.maxShownPanels = maxPanels;
        this.docketToRender = toRender;
    }

    public void setDiscreteDimension(Dimension dim) {
        this.discreteSize = new Dimension(dim);
    }

    public void updateRenderer() {
        if (this.lastModCount != this.docketToRender.getModCount()) {
            this.relayoutDocket();
            this.lastModCount = this.docketToRender.getModCount();
            this.refreshRenderers();
        } else {
            this.refreshRenderers();
            this.validate();
            this.repaint();
        }
    }

    private void refreshRenderers() {
        for (LineRenderer renderer : this.renderers) {
            renderer.refreshRenderingComponent();
        }
    }

    private void relayoutDocket() {
        String comment;
        this.displayablePanels.clear();
        this.removeAll();
        this.invalidate();
        if (this.docketToRender == null) {
            this.setPreferredSize(this.discreteSize);
            return;
        }
        if (this.header == null) {
            this.header = this.panelFactory.createHeaderPanel();
        }
        if (this.footer == null) {
            this.footer = this.panelFactory.createFooterPanel();
        }
        this.setPreferredSize(this.discreteSize);
        JPanel primaryPanel = new JPanel(new BorderLayout());
        this.displayablePanels.add(primaryPanel);
        this.add(primaryPanel);
        primaryPanel.add((Component)this.header, "North");
        primaryPanel.setPreferredSize(this.discreteSize);
        this.header.setDocketToRender(this.docketToRender);
        this.header.setPreferredSize(this.discreteSize);
        int height = this.header.getExpectedHeight(this.discreteSize.width);
        this.header.setPreferredSize(new Dimension(this.discreteSize.width, height));
        DocketItemsPanel firstPanel = this.makeItemSummaryPanel(true);
        primaryPanel.add((Component)firstPanel, "Center");
        primaryPanel.add((Component)this.footer, "South");
        this.footer.setDocketToRender(this.docketToRender);
        this.validate();
        this.renderers.clear();
        List<SummaryLine<?>> printableLines = this.docketToRender.getSummaryLines();
        ArrayList<KTSLine> lines = new ArrayList<KTSLine>(printableLines);
        List<SummaryLine<?>> displayableCourses = this.findCourses(printableLines);
        if (this.docketToRender.getDeletions() != null) {
            lines.addAll(this.docketToRender.getDeletions());
        }
        if (this.docketToRender.getTransfers() != null) {
            lines.addAll(this.docketToRender.getTransfers());
        }
        if (!StringUtils.isEmpty((String)(comment = this.docketToRender.getAccount().getComment()))) {
            lines.add(new KTSLine<String>(comment, null));
        }
        this.insertNotifications(lines, this.docketToRender.getNotifications(), displayableCourses);
        lines.removeAll(this.fillPanel(firstPanel, lines, displayableCourses));
        while (lines.size() > 0) {
            DocketItemsPanel nextPanel = this.makeItemSummaryPanel(false);
            nextPanel.setDrawSeparator(true);
            this.displayablePanels.add(nextPanel);
            this.add(Box.createHorizontalStrut(2));
            this.add(nextPanel);
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + this.discreteSize.width + 2, this.discreteSize.height));
            nextPanel.invalidate();
            this.validate();
            lines.removeAll(this.fillPanel(nextPanel, lines, displayableCourses));
        }
        if (this.displayablePanels.size() > this.maxShownPanels) {
            this.removeAll();
            DefaultScrollPaneModel model = new DefaultScrollPaneModel(this.maxShownPanels, 1);
            model.setItems(this.displayablePanels);
            this.setPreferredSize(new Dimension((this.discreteSize.width + 2) * this.maxShownPanels - 2, this.discreteSize.height));
            CustomScrollPane scrolly = new CustomScrollPane((CustomScrollPaneModel)model, "/utils/ktsmate/images/leftarrow.png", "/utils/ktsmate/images/rightarrow.png");
            scrolly.setDecorationLocation(DecoratorLocation.EastWest);
            scrolly.setPreferredSize(this.getPreferredSize());
            scrolly.removeMouseWheelListener();
            this.add((Component)scrolly);
            this.validate();
        }
    }

    private List<SummaryLine<?>> findCourses(List<SummaryLine<?>> lines) {
        Account relevantAccount = this.docketToRender.getTargetAccount();
        if (relevantAccount == null) {
            relevantAccount = this.docketToRender.getAccount();
        }
        if (!TableAccount.TYPE.toString().equals(relevantAccount.getType())) {
            return Collections.emptyList();
        }
        Course currentCourse = null;
        List courses = Course.getCourses();
        ArrayList firstLines = new ArrayList();
        for (SummaryLine<?> nextLine : lines) {
            Course nextCourse;
            if (nextLine.getSummaries().isEmpty() || (nextCourse = (Course)courses.get(nextLine.getSummaries().get(0).getSalesItem().getCourse())) == null || nextCourse.equals(currentCourse)) continue;
            firstLines.add(nextLine);
            currentCourse = nextCourse;
        }
        return firstLines;
    }

    void setSelected(boolean value) {
        if (this.header != null) {
            this.header.setSelected(value);
            this.header.validate();
            this.header.repaint();
        }
    }

    private List<KTSLine> fillPanel(DocketItemsPanel panel, List<KTSLine> lines, List<SummaryLine<?>> courseLines) {
        KTSLine nextLine;
        LineRenderer renderer;
        if (lines.size() == 0) {
            return lines;
        }
        ArrayList<KTSLine> addedList = new ArrayList<KTSLine>();
        Iterator<KTSLine> iterator = lines.iterator();
        while (iterator.hasNext() && (renderer = panel.addItemToRender(this.docketToRender, nextLine = iterator.next(), courseLines.contains(nextLine))) != null) {
            this.renderers.add(renderer);
            addedList.add(nextLine);
        }
        return addedList;
    }

    private DocketItemsPanel makeItemSummaryPanel(boolean isFirst) {
        Dimension theSize = this.discreteSize;
        if (isFirst) {
            theSize = new Dimension(theSize.width, theSize.height - this.header.getPreferredSize().height);
        }
        DocketItemsPanel panel = this.panelFactory.createSalesLineItemPanel();
        panel.setPreferredSize(theSize);
        panel.setMinimumSize(theSize);
        panel.setMaximumSize(theSize);
        KTSDocketPrinter currentPrinter = KTSMate.getLocalPrinter();
        if (currentPrinter.getAlternateColours() && currentPrinter.getAlternatingColour1() != null && currentPrinter.getAlternatingColour2() != null) {
            if (this.docketToRender.getId() % 2 == 0) {
                panel.setBackground(currentPrinter.getAlternatingColour1());
            } else {
                panel.setBackground(currentPrinter.getAlternatingColour2());
            }
        }
        return panel;
    }

    public boolean headerContains(Point point) {
        if (this.header != null && this.header.isShowing()) {
            return this.header.contains(point);
        }
        return false;
    }

    KTSDocket getRenderedDocket() {
        return this.docketToRender;
    }

    void updateHeader() {
        if (this.header != null) {
            this.header.gotUpdatePanel();
        }
    }

    void dropEverything() {
        this.removeAll();
        this.docketToRender = null;
        this.displayablePanels.clear();
        this.renderers.clear();
        this.header.setDocketToRender(null);
        this.header = null;
        this.footer.setDocketToRender(null);
        this.footer = null;
    }

    protected HeaderPanel getHeaderPanel() {
        return this.header;
    }

    protected FooterPanel getFooterPanel() {
        return this.footer;
    }

    List<LineRenderer> getRenderers() {
        return this.renderers;
    }

    List<JComponent> getDisplayablePanels() {
        return this.displayablePanels;
    }

    private void insertNotifications(List<KTSLine> lines, List<KTSLine> notifications, List<SummaryLine<?>> displayableCourses) {
        if (notifications == null || notifications.isEmpty()) {
            return;
        }
        lines.add(new KTSStringLine(" ", null));
        if (!displayableCourses.isEmpty()) {
            for (int i = 0; i < displayableCourses.size(); ++i) {
                SummaryLine<?> courseLine = displayableCourses.get(i);
                int course = courseLine.getSummaries().get(0).getSalesItem().getCourse();
                ArrayList<KTSLine> addNotify = new ArrayList<KTSLine>();
                boolean keepAdding = false;
                for (KTSLine line : notifications) {
                    if (line instanceof KTSNotifyPrinterLine) {
                        boolean bl = keepAdding = ((KTSNotifyPrinterLine)line).getCourse().getCourseIndex() == course;
                    }
                    if (!keepAdding) continue;
                    addNotify.add(line);
                }
                int index = lines.size();
                if (i < displayableCourses.size() - 1) {
                    index = lines.indexOf(displayableCourses.get(i + 1));
                }
                lines.addAll(index, addNotify);
            }
        } else {
            lines.addAll(notifications);
        }
    }
}

