/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.views.live;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import utils.ktsmate.docket.KTSDocketController;
import utils.ktsmate.docket.KTSDocketControllerVendor;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.gui.renderer.ItemSummaryRenderer;
import utils.ktsmate.gui.renderer.LineRenderer;

public class ControllerItemSummaryRenderer<T>
implements LineRenderer<T> {
    private KTSDocketControllerVendor vendor;
    private ItemSummaryRenderer<T> renderer;

    public ControllerItemSummaryRenderer(ItemSummaryRenderer<T> renderer, KTSDocketControllerVendor controllerVendor) {
        this.vendor = controllerVendor;
        this.renderer = renderer;
        this.installListeners();
    }

    private void installListeners() {
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ControllerItemSummaryRenderer.this.itemTapped((Component)e.getSource());
            }
        };
        for (LineRenderer nextRenderer : this.renderer.getLineRenderers()) {
            nextRenderer.getRenderingComponent().addMouseListener(adapter);
        }
    }

    private void itemTapped(Component comp) {
        KTSDocketController docketController = this.vendor.getControllerFor(this.renderer.getDocket());
        if (docketController != null) {
            docketController.lineTapped(this.renderer.getLineRendererForComponent(comp).getRenderedLine());
            this.renderer.refreshRenderers();
        }
    }

    @Override
    public KTSLine<T> getRenderedLine() {
        return this.renderer.getRenderedLine();
    }

    @Override
    public JComponent getRenderingComponent() {
        return this.renderer.getRenderingComponent();
    }

    @Override
    public void refreshRenderingComponent() {
        this.renderer.refreshRenderingComponent();
    }

    @Override
    public void adjustRendererHeightToFit(int width) {
        this.renderer.adjustRendererHeightToFit(width);
    }
}

