/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.gui.views.live;

import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ordermate.database.hardware.physical.kts.KTSCommand;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import utils.ktsmate.KTSMate;
import utils.ktsmate.KTSNavBar;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSDocketControllerVendor;
import utils.ktsmate.docket.KTSListController;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.gui.KTSUIHelper;
import utils.ktsmate.gui.NavButtonFlasher;
import utils.ktsmate.gui.views.AbstractDocketListView;
import utils.ktsmate.gui.views.DocketItemsPanel;
import utils.ktsmate.gui.views.DocketPanelFactory;
import utils.ktsmate.gui.views.FooterPanel;
import utils.ktsmate.gui.views.HeaderPanel;
import utils.ktsmate.gui.views.TabularDocketListView;
import utils.ktsmate.gui.views.live.ControllerHeaderPanel;
import utils.ktsmate.gui.views.live.LiveLineRendererFactory;

public class LiveView
extends AbstractDocketListView {
    private static final int DEFAULT_STAT_REFRESH = 5000;
    public final Signal showBump = Signals.createSignal();
    public final Signal showOnHold = Signals.createSignal();
    public final Signal multiBump = Signals.createSignal();
    public final Signal putOnHold = Signals.createSignal();
    private KTSDocketControllerVendor vendor;
    private Timer statTimer;

    public LiveView(KTSListController controller, KTSDocketControllerVendor controllerVendor) {
        super(controller);
        this.vendor = controllerVendor;
        this.putOnHold.disconnectAll();
        this.multiBump.disconnectAll();
        this.putOnHold.connect((Object)this, "gotPutOnHold");
        this.multiBump.connect((Object)this, "gotMultiBump");
    }

    @Override
    protected TabularDocketListView createListView() {
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        return new TabularDocketListView(new LiveViewFactory(), printer.getNumRows(), printer.getNumColumns(), printer.getAnimTime(), null);
    }

    @Override
    protected KTSNavBar createNavBar() {
        return new LiveNav();
    }

    @Override
    public KTSDocketState getViewState() {
        return KTSDocketState.Live;
    }

    @Override
    public void display() {
        if (this.statTimer != null) {
            this.statTimer.cancel();
        }
        super.display();
        this.statTimer = new Timer();
        this.statTimer.schedule((TimerTask)new LiveStatsTask(), 1000L, 5000L);
    }

    public void gotPutOnHold() {
        List<KTSDocket> toHold = this.getSelectedDockets();
        for (KTSDocket nextDocket : toHold) {
            this.listController.changeDocketState(nextDocket, KTSDocketState.Hold, Integer.MAX_VALUE);
        }
        this.updateTabularView();
    }

    public void gotMultiBump() {
        List<KTSDocket> toBump = this.getSelectedDockets();
        for (KTSDocket nextDocket : toBump) {
            this.listController.changeDocketState(nextDocket, KTSDocketState.Bump, 0);
        }
        this.updateTabularView();
    }

    protected void bumpSelectedDocket() {
        KTSDocket docket;
        List<KTSDocket> toBump = this.getSelectedDockets();
        if (toBump.isEmpty() && this.getView().getNumDockets() > 0 && (docket = this.getView().getDocketForIndex(0)) != null) {
            toBump = Collections.singletonList(docket);
        }
        for (KTSDocket nextDocket : toBump) {
            this.listController.changeDocketState(nextDocket, KTSDocketState.Bump, 0);
        }
        this.updateTabularView();
    }

    protected void bumpSelectedRow() {
        KTSDocket docket = this.getSelectedDocket();
        if (docket != null) {
            KTSLine line = docket.getSelectedLine();
            this.vendor.getControllerFor(docket).lineTapped(line);
        }
    }

    @Override
    public void gotDocketSelected() {
        super.gotDocketSelected();
        ((LiveNav)this.getNavBar()).multiBumpButton.setEnabled(!this.getView().getSelectedDockets().isEmpty());
        ((LiveNav)this.getNavBar()).putOnHoldButton.setEnabled(!this.getView().getSelectedDockets().isEmpty());
    }

    public void flashOnHoldButton(Color color) {
        ((LiveNav)this.getNavBar()).flashOnHoldButton(color);
    }

    @Override
    public boolean doCommand(KTSCommand command) {
        boolean handled = super.doCommand(command);
        if (!handled) {
            if (KTSCommand.Hold.equals((Object)command)) {
                handled = true;
                this.gotPutOnHold();
            } else if (KTSCommand.ViewHolds.equals((Object)command)) {
                handled = true;
                this.showOnHold.emit();
            } else if (KTSCommand.ViewBumped.equals((Object)command)) {
                handled = true;
                this.showBump.emit();
            } else if (KTSCommand.Cancel.equals((Object)command)) {
                handled = true;
                this.getView().deselectDockets();
            } else if (KTSCommand.Ok.equals((Object)command)) {
                handled = true;
                if (this.getView().getSelectedDocket() != null && this.getView().getSelectedDocket().getSelectedLine() != null) {
                    this.bumpSelectedRow();
                } else {
                    this.bumpSelectedDocket();
                }
            }
        }
        return handled;
    }

    @Override
    public void gotDocketActioned(KTSDocket docket) {
        this.getView().deselectDockets();
        this.getView().toggleDocketSelection(docket);
        this.bumpSelectedDocket();
    }

    private class LiveStatsTask
    extends TimerTask {
        private LiveStatsTask() {
        }

        @Override
        public void run() {
            int tally = 0;
            long tallyTime = 0L;
            long now = System.currentTimeMillis();
            for (KTSDocketState state : KTSDocketState.values()) {
                ArrayList<KTSDocket> list = new ArrayList<KTSDocket>((Collection<KTSDocket>)LiveView.this.listController.getDocketList(state));
                tally += list.size();
                for (KTSDocket nextDocket : list) {
                    if (!nextDocket.getDocketState().equals((Object)KTSDocketState.Bump)) {
                        long offset = now - (nextDocket.getLastEvent() != null ? nextDocket.getLastEvent().getTime() : 0L);
                        tallyTime = tallyTime + offset + (long)nextDocket.getNonBumpedTime();
                        continue;
                    }
                    tallyTime += (long)nextDocket.getNonBumpedTime();
                }
            }
            final String tallyText = tally != 1 ? tally + " Dockets" : tally + " Docket";
            if (tally > 0) {
                tallyTime /= (long)(1000 * tally);
            }
            StringBuilder SB = new StringBuilder("Avg Time - ");
            final String averageText = SB.append(KTSUIHelper.makeTimeString(tallyTime)).toString();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (KTSMate.getLocalPrinter().isShowStatusBar()) {
                        ((LiveNav)LiveView.this.getNavBar()).updateStats(tallyText, averageText);
                    } else {
                        ((LiveNav)LiveView.this.getNavBar()).updateStats("", "");
                    }
                }
            });
        }
    }

    class LiveViewFactory
    implements DocketPanelFactory {
        LiveViewFactory() {
        }

        @Override
        public HeaderPanel createHeaderPanel() {
            return new ControllerHeaderPanel(LiveView.this.vendor);
        }

        @Override
        public FooterPanel createFooterPanel() {
            return new FooterPanel();
        }

        @Override
        public DocketItemsPanel createSalesLineItemPanel() {
            return new DocketItemsPanel(new LiveLineRendererFactory(LiveView.this.vendor));
        }
    }

    private class LiveNav
    extends KTSNavBar {
        private JButton showBumpButton;
        private JButton multiBumpButton;
        private JButton putOnHoldButton;
        private JButton showOnHoldButton;
        private JLabel numDocketsLabel;
        private JLabel averageTimeLabel;
        private NavButtonFlasher flashTimer;

        private LiveNav() {
        }

        @Override
        protected void setupNav() {
            super.setupNav();
            this.showBumpButton = this.constructButton((Icon)IconLoader.get((String)"/utils/ktsmate/images/bumped.png"), "Bumped", "showBumpedButton", LiveView.this.showBump);
            this.multiBumpButton = this.constructButton((Icon)IconLoader.get((String)"/utils/ktsmate/images/multibump.png"), "Bump", "multiBumpButton", LiveView.this.multiBump);
            this.multiBumpButton.setEnabled(false);
            this.putOnHoldButton = this.constructButton((Icon)IconLoader.get((String)"/utils/ktsmate/images/hold.png"), "Hold", "putOnHoldButton", LiveView.this.putOnHold);
            this.putOnHoldButton.setEnabled(false);
            this.showOnHoldButton = this.constructButton((Icon)IconLoader.get((String)"/utils/ktsmate/images/held.png"), "View Holds", "showOnHoldButton", LiveView.this.showOnHold);
            this.addLeft(this.showBumpButton, 0);
            this.addRight(this.multiBumpButton);
            this.addRight(this.putOnHoldButton);
            this.addRight(this.showOnHoldButton);
            this.addLeft(this.createStatsPanel());
        }

        private void updateStats(String numDockets, String averageTime) {
            this.numDocketsLabel.setText(numDockets);
            this.averageTimeLabel.setText(averageTime);
        }

        private JComponent createStatsPanel() {
            if (KTSMate.getLocalPrinter().isShowStatusBar()) {
                this.numDocketsLabel = new JLabel("0 Dockets");
                this.averageTimeLabel = new JLabel("Avg Time - ");
            } else {
                this.numDocketsLabel = new JLabel("");
                this.averageTimeLabel = new JLabel("");
            }
            this.numDocketsLabel.setName("lblNumDockets");
            this.averageTimeLabel.setName("lblAvgTime");
            JPanel dodgyStatsPanel = new JPanel(new GridLayout(2, 1, 5, 5));
            dodgyStatsPanel.add(this.numDocketsLabel);
            dodgyStatsPanel.add(this.averageTimeLabel);
            Font dodgyFont = new Font("SansSerif", 1, 16);
            this.numDocketsLabel.setFont(dodgyFont);
            this.averageTimeLabel.setFont(dodgyFont);
            return dodgyStatsPanel;
        }

        private void flashOnHoldButton(Color color) {
            if (this.flashTimer == null) {
                this.flashTimer = new NavButtonFlasher(this.showOnHoldButton);
            }
            this.flashTimer.startFlashing(color);
        }
    }
}

