/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.milestones;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.hardware.physical.kts.KTSMilestone;
import ordermate.database.hardware.physical.kts.KTSMilestoneInclude;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSDocketStateEvent;
import utils.ktsmate.docket.KTSDocketStateListener;
import utils.ktsmate.milestones.Milestone;

public class KTSMilestoneManager
implements KTSDocketStateListener {
    private static final long TIMER_DELAY = 1000L;
    private final Map<KTSDocket, Milestone> docketMilestones = new HashMap<KTSDocket, Milestone>();
    private final List<Milestone> milestones;
    private static KTSMilestoneManager instance;

    public static final void setupInstance(KTSDocketPrinter printer) {
        if (instance != null) {
            throw new IllegalArgumentException("Cannot recreate the KTSMilestoneManager instance");
        }
        instance = new KTSMilestoneManager(printer);
    }

    public static final KTSMilestoneManager getInstance() {
        return instance;
    }

    private KTSMilestoneManager(KTSDocketPrinter localPrinter) {
        this.milestones = this.makeMilestones(localPrinter);
        OrderMate.LOG.info("Made milestones: " + this.milestones.size());
        if (!this.milestones.isEmpty()) {
            TimerTask updateTask = new TimerTask(){

                @Override
                public void run() {
                    KTSMilestoneManager.this.updateMilestones();
                }
            };
            new Timer().schedule(updateTask, 1000L, 1000L);
        }
    }

    private List<Milestone> makeMilestones(KTSDocketPrinter printer) {
        HashSet<Milestone> stoneSet = new HashSet<Milestone>();
        for (KTSMilestone nextStone : printer.getMilestones()) {
            stoneSet.add(new Milestone(nextStone));
        }
        ArrayList<Milestone> stones = new ArrayList<Milestone>(stoneSet);
        Collections.sort(stones, new Comparator<Milestone>(){

            @Override
            public int compare(Milestone o1, Milestone o2) {
                return o1.getMilliSeconds() - o2.getMilliSeconds();
            }
        });
        return stones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMilestones() {
        HashSet<KTSDocket> docketSet;
        Map<KTSDocket, Milestone> map = this.docketMilestones;
        synchronized (map) {
            docketSet = new HashSet<KTSDocket>(this.docketMilestones.keySet());
        }
        long now = System.currentTimeMillis();
        for (KTSDocket nextDocket : docketSet) {
            Milestone stone = this.figureOutStoneFor(nextDocket, now);
            Map<KTSDocket, Milestone> map2 = this.docketMilestones;
            synchronized (map2) {
                if (this.docketMilestones.containsKey(nextDocket)) {
                    this.docketMilestones.put(nextDocket, stone);
                }
            }
        }
    }

    private Milestone figureOutStoneFor(KTSDocket docket, long now) {
        Milestone lastStone = this.docketMilestones.get(docket);
        int index = this.milestones.indexOf(lastStone);
        int liveTime = this.getTotalLiveTime(docket, now);
        int nonBumpedTime = this.getTotalNonBumpedTime(docket, now);
        if (index == -1) {
            index = 0;
        }
        for (int i = index; i < this.milestones.size(); ++i) {
            int time;
            Milestone nextStone = this.milestones.get(i);
            if (KTSMilestoneInclude.LiveOnly.equals((Object)nextStone.getInclude())) {
                time = liveTime;
            } else if (KTSMilestoneInclude.HoldOnly.equals((Object)nextStone.getInclude())) {
                time = nonBumpedTime - liveTime;
            } else if (KTSMilestoneInclude.TotalTime.equals((Object)nextStone.getInclude())) {
                time = nonBumpedTime;
            } else {
                throw new IllegalArgumentException("Cannot perform milestone calculation on include: " + nextStone.getInclude());
            }
            if (time < nextStone.getMilliSeconds()) continue;
            lastStone = nextStone;
        }
        return lastStone;
    }

    private int getTotalNonBumpedTime(KTSDocket docket, long now) {
        int time = docket.getNonBumpedTime();
        if (docket.getLastEvent() != null) {
            time += (int)(now - docket.getLastEvent().getTime());
        }
        return time;
    }

    private int getTotalLiveTime(KTSDocket docket, long now) {
        int time = docket.getLiveTime();
        if (KTSDocketState.Live.equals((Object)docket.getDocketState()) && docket.getLastEvent() != null) {
            time += (int)(now - docket.getLastEvent().getTime());
        }
        return time;
    }

    public Milestone getMilestoneForDocket(KTSDocket docket) {
        return this.docketMilestones.get(docket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void docketStateChanged(KTSDocketStateEvent event) {
        if (event.getDocket() == null) {
            return;
        }
        if (event.getToState().equals((Object)KTSDocketState.Bump)) {
            Map<KTSDocket, Milestone> map = this.docketMilestones;
            synchronized (map) {
                this.docketMilestones.remove(event.getDocket());
            }
        }
        Map<KTSDocket, Milestone> map = this.docketMilestones;
        synchronized (map) {
            this.docketMilestones.put(event.getDocket(), null);
        }
    }

    public List<Milestone> getMilestones() {
        return Collections.unmodifiableList(this.milestones);
    }
}

