/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.milestones;

import java.awt.Color;
import ordermate.database.hardware.physical.kts.KTSMilestone;
import ordermate.database.hardware.physical.kts.KTSMilestoneAction;
import ordermate.database.hardware.physical.kts.KTSMilestoneInclude;

public final class Milestone {
    private final Color colour;
    private final int millisSeconds;
    private final KTSMilestoneAction action;
    private final KTSMilestoneInclude include;
    private final int thickness;

    Milestone(KTSMilestone milestone) {
        this.colour = milestone.getColour();
        this.millisSeconds = milestone.getSeconds() * 1000;
        this.action = milestone.getAction();
        this.include = milestone.getInclude();
        this.thickness = Math.max(0, milestone.getLineThickness());
    }

    public int getMilliSeconds() {
        return this.millisSeconds;
    }

    public Color getColor() {
        return this.colour;
    }

    public KTSMilestoneAction getAction() {
        return this.action;
    }

    public KTSMilestoneInclude getInclude() {
        return this.include;
    }

    public int getThickness() {
        return this.thickness;
    }
}

