/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.schedule;

import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import utils.ktsmate.startup.DeleteStaleDocketsTask;

public class KTSScheduleAndCleanTask
extends TimerTask {
    private boolean shouldSchedule;

    public KTSScheduleAndCleanTask(boolean shouldScheduleNextTask) {
        this.shouldSchedule = shouldScheduleNextTask;
    }

    public KTSScheduleAndCleanTask() {
        this.shouldSchedule = true;
    }

    @Override
    public void run() {
        this.performTask();
        if (this.shouldSchedule) {
            this.schedule();
        }
    }

    public void performTask() {
        new DeleteStaleDocketsTask().run();
        SystemCurrentInfo.refreshReference();
    }

    private void schedule() {
        if (SystemProperty.getInstance().isManualChangeOfDay()) {
            OrderMate.LOG.info("Will not schedule KTS Clean, manual change of day");
            return;
        }
        Date changeTime = TradingDay.getChangeOfDayTime((Date)new Date(), (Date)SystemProperty.getInstance().getChangeDayTime());
        Calendar cal = Calendar.getInstance();
        cal.setTime(changeTime);
        cal.add(12, 10);
        changeTime = cal.getTime();
        Timer theTimer = new Timer(true);
        theTimer.schedule((TimerTask)new KTSScheduleAndCleanTask(), changeTime);
    }
}

