/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import java.util.ArrayList;
import java.util.Collection;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.DefaultKTSListController;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSDocketStateEvent;
import utils.ktsmate.gui.milestones.KTSMilestoneMonitor;
import utils.ktsmate.gui.milestones.KTSMilestoneMonitorPool;
import utils.ktsmate.gui.milestones.LiveMilestoneMonitor;
import utils.ktsmate.milestones.KTSMilestoneManager;

public class CreateMilestonesTask
extends AbstractTask {
    public String getName() {
        return "Milestones Manager Creation";
    }

    protected void performTask() throws Exception {
        KTSMilestoneManager.setupInstance(KTSMate.getLocalPrinter());
        KTSMilestoneManager manager = KTSMilestoneManager.getInstance();
        DefaultKTSListController listController = KTSMate.getListController();
        listController.addDocketStateListener(manager);
        this.emitProgress();
        ArrayList<KTSDocket> all = new ArrayList<KTSDocket>((Collection<KTSDocket>)KTSMate.getListController().getDocketList(KTSDocketState.Live));
        all.addAll((Collection<KTSDocket>)KTSMate.getListController().getDocketList(KTSDocketState.Hold));
        for (KTSDocket nextDocket : all) {
            manager.docketStateChanged(new KTSDocketStateEvent(nextDocket, nextDocket.getDocketState(), nextDocket.getDocketState()));
        }
        this.emitProgress();
        KTSMilestoneMonitorPool monitors = KTSMilestoneMonitorPool.getInstance();
        monitors.registerMonitorFor(KTSDocketState.Live, new LiveMilestoneMonitor(listController));
        monitors.registerMonitorFor(KTSDocketState.Hold, new KTSMilestoneMonitor(KTSDocketState.Hold, listController));
        this.emitProgress();
    }

    protected int getTotalSubTasks() {
        return 3;
    }
}

