/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.startup;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.guicore.task.AbstractTask;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import ordermate.OrderMate;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.TradingDay;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.DefaultKTSListController;

public class DeleteStaleDocketsTask
extends AbstractTask {
    private DefaultKTSListController myController;
    private static final String CURRENT_DAY_FILE = "currentday.kts";

    protected void performTask() throws Exception {
        this.myController = KTSMate.getListController();
        StringBuilder cdf = new StringBuilder(KTSMate.getIO().getMainDir());
        cdf.append(CURRENT_DAY_FILE);
        File file = new File(cdf.toString());
        file.getParentFile().mkdirs();
        boolean wipeBumpedDockets = false;
        Long currentId = TradingDay.getCurrentTradingDay().getID();
        if (file.exists()) {
            Long expectedId = null;
            try {
                FileInputStream fin = new FileInputStream(file);
                DataInputStream in = new DataInputStream(fin);
                expectedId = in.readLong();
                in.close();
            }
            catch (IOException ex) {
                OrderMateLog.LOG.warn("Unable to open file to check current day:" + file, (Throwable)ex);
            }
            OrderMate.LOG.info("Current ID:" + currentId + " expected:" + expectedId);
            if (expectedId != null) {
                boolean bl = wipeBumpedDockets = !expectedId.equals(currentId);
            }
        }
        if (wipeBumpedDockets) {
            this.myController.deleteAllBumpedDockets();
        }
        this.emitProgress();
        try {
            FileOutputStream fout = new FileOutputStream(file);
            DataOutputStream out = new DataOutputStream(fout);
            out.writeLong(currentId);
            out.flush();
            out.close();
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn("Unable to open file to check current day:" + file, (Throwable)ex);
        }
        this.emitProgress();
        OrderMate.LOG.info("Removing dangling dockets");
        this.myController.clearStaleDockets();
        this.emitProgress();
        SystemCurrentInfo.refreshReference();
    }

    public String getName() {
        return "Delete Stale Dockets";
    }

    protected int getTotalSubTasks() {
        return 3;
    }
}

