/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.startup;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.guicore.task.AbstractTask;
import ordermate.OrderMate;
import utils.ktsmate.KTSMate;

public class EnsurePrinterAvailableTask
extends AbstractTask {
    private int NUM_RETRIES = 60;
    private long DELAY = 1000L;

    public String getName() {
        return "Printer availability check";
    }

    protected void performTask() throws Exception {
        this.waitOnPrinter();
    }

    private void waitOnPrinter() throws IllegalArgumentException {
        for (int i = 0; i <= this.NUM_RETRIES; ++i) {
            try {
                if (KTSMate.getLocalPrinter() != null) {
                    return;
                }
                OrderMateLog.LOG.warn("KTSDocketPrinter is not available, trying again");
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot call KTSMate.getLocalPrinter. Servermate up?", (Throwable)ex);
            }
            try {
                Thread.sleep(this.DELAY);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (i != this.NUM_RETRIES) continue;
            throw new IllegalArgumentException("Cannot initiate Printer, none available in the database.");
        }
    }

    protected int getTotalSubTasks() {
        return 0;
    }
}

