/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.startup;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import com.vaadin.server.VaadinServlet;
import java.util.List;
import javax.servlet.Servlet;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import utils.ktsmate.KTSMate;
import utils.ktsmate.web.account.AccountBarcodeUI;
import utils.ktsmate.web.ui.TPXWebFace;

public class KTSJettyTask
extends AbstractTask {
    private String resourcePath = "C:/webapp";
    private int port = 8976;

    public String getName() {
        return "TPX Jetty";
    }

    protected void performTask() throws Exception {
        String basePort;
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        this.resourcePath = printer.getWebAppLocation();
        this.port = printer.getWebAppPort();
        String basePath = Config.getStringValue((String)"web-base");
        if (basePath == null || basePath.isEmpty()) {
            basePath = this.resourcePath;
        }
        if ((basePort = Config.getStringValue((String)"web-port")) != null && !basePort.isEmpty()) {
            try {
                this.port = Integer.parseInt(basePort);
            }
            catch (Exception exception) {}
        } else if (printer != null && !printer.getPort().isEmpty() && !printer.getPort().equals("None")) {
            try {
                this.port = Integer.parseInt(printer.getPort());
            }
            catch (Exception exception) {}
        } else {
            this.port = this.getNextPrinterPort();
        }
        OrderMate.LOG.info("web-base set to " + basePath + " port set to " + this.port);
        String contextPath = "/tpx";
        Server server = new Server(this.port);
        WebAppContext context = new WebAppContext();
        context.setContextPath(contextPath);
        context.setResourceBase(basePath);
        context.setClassLoader(Thread.currentThread().getContextClassLoader());
        ServletHolder webFaceServlet = this.makeWebFaces();
        ServletHolder accountBarcodeServlet = this.makeAccountBarcode();
        if (!Config.isDebuging()) {
            webFaceServlet.setInitParameter("productionMode", "true");
            accountBarcodeServlet.setInitParameter("productionMode", "true");
        }
        context.addServlet(webFaceServlet, "/webface/*");
        context.addServlet(webFaceServlet, "/VAADIN/*");
        context.addServlet(accountBarcodeServlet, "/accountbarcode/*");
        context.addServlet(accountBarcodeServlet, "/VAADIN/*");
        server.setHandler((Handler)context);
        server.start();
        if (printer != null && printer.getUserName() != null && !printer.getUserName().isEmpty()) {
            printer.setPort(Integer.toString(this.port));
            printer.save();
        }
    }

    private ServletHolder makeWebFaces() {
        VaadinServlet servlet = new VaadinServlet();
        ServletHolder vaadinLoader = new ServletHolder((Servlet)servlet);
        vaadinLoader.setInitParameter("UI", TPXWebFace.class.getCanonicalName());
        vaadinLoader.setInitParameter("heartbeatInterval", "28800");
        vaadinLoader.setInitParameter("closeIdleSessions", "false");
        return vaadinLoader;
    }

    private ServletHolder makeAccountBarcode() {
        VaadinServlet servlet = new VaadinServlet();
        ServletHolder vaadinLoader = new ServletHolder((Servlet)servlet);
        vaadinLoader.setInitParameter("UI", AccountBarcodeUI.class.getCanonicalName());
        vaadinLoader.setInitParameter("session-timeout", "-1");
        return vaadinLoader;
    }

    protected int getTotalSubTasks() {
        return 1;
    }

    private int getNextPrinterPort() {
        int lastPort = 0;
        List<KTSDocketPrinter> printers = KTSMate.getLocalPrinters();
        for (KTSDocketPrinter prt : printers) {
            if (prt.getPort().equals("None")) continue;
            try {
                int prtPort = Integer.parseInt(prt.getPort());
                lastPort = Math.max(lastPort, prtPort);
            }
            catch (Exception exception) {}
        }
        lastPort = lastPort != 0 ? (lastPort += 10) : this.port;
        return lastPort;
    }
}

