/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.startup;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.startup.DynamicPortRangeRMIStartupTask;
import org.apache.commons.lang.ArrayUtils;
import utils.ktsmate.KTSMate;

public class KTSPrinterPortRangeRMIStartupTask
extends DynamicPortRangeRMIStartupTask {
    public KTSPrinterPortRangeRMIStartupTask() {
        super(11106, 10, null, OrderMate.KTSMATE_RMI_PORTS);
    }

    protected void adjustPorts() {
        super.adjustPorts();
        Integer oldPort = KTSMate.getLocalPrinter().getRmiPort();
        if (oldPort != null && !Arrays.asList(ArrayUtils.toObject((int[])this.getPorts())).contains(oldPort)) {
            int[] ports = this.getPorts();
            int[] newPorts = new int[ports.length + 1];
            newPorts[0] = oldPort;
            System.arraycopy(ports, 0, newPorts, 1, ports.length);
            OrderMate.LOG.info("Trying previous port for RMI: " + Arrays.toString(newPorts));
            this.setPorts(newPorts);
        }
    }

    protected String getUsername() {
        return KTSMate.getLocalPrinter().getUserName();
    }

    protected Map<String, Integer> getTerminals(List<InetAddress> localIpAddresses) throws Exception {
        Object[] myIps = null;
        try {
            myIps = new String[]{"localhost", "127.0.0.1", InetAddress.getLocalHost().getHostAddress()};
        }
        catch (UnknownHostException ex) {
            OrderMateLog.LOG.warn("Couldn't retrieve local host.", (Throwable)ex);
            myIps = new String[]{"localhost", "127.0.0.1"};
        }
        List printers = PersistenceManager.getObjectList(KTSDocketPrinter.class, (String)Query.select(KTSDocketPrinter.class).active(KTSDocketPrinter.class).wherePropertyIn(KTSDocketPrinter.Properties.IP_ADDRESS, myIps).toString());
        HashMap<String, Integer> userPorts = new HashMap<String, Integer>();
        for (KTSDocketPrinter printer : printers) {
            userPorts.put(printer.getUserName(), printer.getRmiPort());
        }
        return userPorts;
    }

    protected void savePort(int sharePort) {
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        printer.setRmiPort(Integer.valueOf(sharePort));
        printer.save();
    }
}

