/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.file.FileZipper;
import java.io.File;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.misc.FTPHelper;
import utils.ktsmate.KTSMate;

public class KTSWebDependenciesTask
extends AbstractTask {
    public String getName() {
        return "KTS Web Dependencies Download Task";
    }

    protected void performTask() throws Exception {
        this.downloadAndExtractWebFace();
        this.emitProgress();
    }

    private void checkAndMakeTempDir() {
        File jrePathFile = new File("C:/temp");
        if (jrePathFile.exists()) {
            return;
        }
        jrePathFile.mkdirs();
    }

    protected int getTotalSubTasks() {
        return 1;
    }

    private boolean downloadAndExtractWebFace() {
        String productInstallPath = this.getInstallPath();
        try {
            File jrePathFile = new File(productInstallPath);
            if (jrePathFile.exists()) {
                OrderMate.LOG.info("Directory already exists :)");
                return true;
            }
            OrderMate.LOG.info("Trying to download Webapp");
            this.checkAndMakeTempDir();
            boolean result = FTPHelper.downloadFile((String)"/Scripts/TPXWebFaceScript/tpxwebapp.zip", (String)"C:/temp/tpxwebapp.zip");
            if (!result) {
                OrderMate.LOG.warn("Could not download WebApp");
                return true;
            }
            OrderMate.LOG.info("Trying to extract file : " + productInstallPath + " to webapp");
            result = jrePathFile.mkdirs();
            if (!result) {
                OrderMate.LOG.warn("Could not create path for WebApp");
                return true;
            }
            boolean unzipped = new FileZipper().unzipIt("C:/temp/tpxwebapp.zip", productInstallPath);
            if (!unzipped) {
                OrderMate.LOG.warn("Failed to unzip tpxwebapp.zip to " + productInstallPath + "! Could not install webapp");
                return true;
            }
            OrderMate.LOG.info("KTSWebDependenciesTask: Successfully unpacked Webapp to Webapp directory.");
            return true;
        }
        catch (Exception e) {
            OrderMate.LOG.error(e.getMessage(), (Throwable)e);
            return true;
        }
    }

    private String getInstallPath() {
        KTSDocketPrinter printer = KTSMate.getLocalPrinter();
        return printer.getWebAppLocation();
    }
}

