/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.summary;

import au.com.ordermate.pipeline.AbstractPipe;
import au.com.ordermate.pipeline.GenericPipe;
import au.com.ordermate.pipeline.GenericPipeline;
import java.util.Collection;
import java.util.List;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.printSummary.SummaryGroupCreator;
import ordermate.database.sales.printSummary.collecting.SalesItemSummaryCollection;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.summary.SalesItemSummaryGroupCollection;
import utils.ktsmate.summary.pipes.ItemLevelAggregationStrategy;
import utils.ktsmate.summary.pipes.KTSConverter;
import utils.ktsmate.summary.pipes.grouping.ItemSummaryGroupingStrategy;
import utils.ktsmate.summary.pipes.grouping.NoGroupingStrategy;
import utils.ktsmate.summary.pipes.sorting.ByNameSummarySortingStrategy;
import utils.ktsmate.summary.pipes.sorting.BySequenceGroupSortingStrategy;

public class KTSSummaryPipeline {
    private GenericPipeline<Collection<KTSDocket>, List<KTSLine>> pipeline = new GenericPipeline(AbstractPipe.castToGeneric(Collection.class), AbstractPipe.castToGeneric(List.class));
    private GenericPipe<Collection<KTSDocket>, Collection<SalesItemSummary>> aggregationStrategy = new ItemLevelAggregationStrategy();
    private GenericPipe<Collection<SalesItemSummary>, Collection<SalesItemSummaryCollection<?>>> groupStrategy = new NoGroupingStrategy();
    private GenericPipe<Collection<SalesItemSummaryCollection<?>>, List<SalesItemSummaryCollection<?>>> groupSortingStrategy = new BySequenceGroupSortingStrategy();
    private GenericPipe<List<SalesItemSummaryGroupCollection<?>>, List<SalesItemSummaryGroupCollection<?>>> itemSortingStrategy = new ByNameSummarySortingStrategy();
    private KTSConverter ktsConverter = new KTSConverter();

    public List<KTSLine> process(Collection<KTSDocket> dockets) {
        ItemSummaryGroupingStrategy summaryGroupingStrategy = new ItemSummaryGroupingStrategy(SummaryGroupCreator.getStrategyByName((String)KTSMate.getLocalPrinter().getSummaryItemGroupStrategy()));
        this.pipeline.clearPipes();
        this.pipeline.addPipe(this.aggregationStrategy);
        this.pipeline.addPipe(this.groupStrategy);
        this.pipeline.addPipe(this.groupSortingStrategy);
        this.pipeline.addPipe((GenericPipe)summaryGroupingStrategy);
        this.pipeline.addPipe(this.itemSortingStrategy);
        this.pipeline.addPipe((GenericPipe)this.ktsConverter);
        return (List)this.pipeline.pump(dockets);
    }

    public void setAggregationStrategy(GenericPipe<Collection<KTSDocket>, Collection<SalesItemSummary>> aggregator) {
        this.aggregationStrategy = aggregator;
    }

    public void setGroupSortingStrategy(GenericPipe<Collection<SalesItemSummaryCollection<?>>, List<SalesItemSummaryCollection<?>>> sorter) {
        this.groupSortingStrategy = sorter;
    }

    public void setItemSortingStrategy(GenericPipe<List<SalesItemSummaryGroupCollection<?>>, List<SalesItemSummaryGroupCollection<?>>> sorter) {
        this.itemSortingStrategy = sorter;
    }

    public void setGroupStrategy(GenericPipe<Collection<SalesItemSummary>, Collection<SalesItemSummaryCollection<?>>> groupStrategy) {
        this.groupStrategy = groupStrategy;
    }
}

