/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.summary;

import ordermate.database.hardware.physical.kts.KTSSummaryGroupingStrategyType;
import ordermate.database.hardware.physical.kts.KTSSummarySortingStrategyType;
import utils.ktsmate.summary.KTSSummaryAggregationStrategy;
import utils.ktsmate.summary.KTSSummaryGroupSortingStrategy;
import utils.ktsmate.summary.KTSSummaryGroupingStrategy;
import utils.ktsmate.summary.KTSSummaryItemSortingStrategy;
import utils.ktsmate.summary.pipes.ItemLevelAggregationStrategy;
import utils.ktsmate.summary.pipes.grouping.ByInventoryCategoryGroupingStrategy;
import utils.ktsmate.summary.pipes.grouping.NoGroupingStrategy;
import utils.ktsmate.summary.pipes.sorting.ByNameSummarySortingStrategy;
import utils.ktsmate.summary.pipes.sorting.ByQuantitySummarySortingStrategy;
import utils.ktsmate.summary.pipes.sorting.BySequenceGroupSortingStrategy;

public class KTSSummaryStrategyFactory {
    public KTSSummaryAggregationStrategy createAggregationStrategy() {
        return new ItemLevelAggregationStrategy();
    }

    public KTSSummaryGroupingStrategy createGroupingStrategy(KTSSummaryGroupingStrategyType type) {
        if (type == KTSSummaryGroupingStrategyType.None) {
            return new NoGroupingStrategy();
        }
        if (type == KTSSummaryGroupingStrategyType.Category) {
            return new ByInventoryCategoryGroupingStrategy();
        }
        throw new IllegalArgumentException("Given Summary Grouping Strategy Type not recognised");
    }

    public KTSSummaryGroupSortingStrategy createGroupSortingStrategy() {
        return new BySequenceGroupSortingStrategy();
    }

    public KTSSummaryItemSortingStrategy createItemSortingStrategy(KTSSummarySortingStrategyType type) {
        if (type == KTSSummarySortingStrategyType.Name) {
            return new ByNameSummarySortingStrategy();
        }
        if (type == KTSSummarySortingStrategyType.Quantity) {
            return new ByQuantitySummarySortingStrategy();
        }
        throw new IllegalArgumentException("Given Summary Sorting Strategy Type not recognised");
    }
}

