/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.summary.pipes;

import au.com.ordermate.units.SalesQuantity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.SalesLineItem;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.docket.line.SummaryGroupLine;
import utils.ktsmate.docket.line.SummaryItemLine;
import utils.ktsmate.docket.line.SummaryLine;
import utils.ktsmate.summary.KTSSummaryAggregationStrategy;

public class ItemLevelAggregationStrategy
extends KTSSummaryAggregationStrategy {
    @Override
    public Collection<SalesItemSummary> aggregate(Collection<KTSDocket> dockets) {
        HashMap<SalesItem, KTSItemSummary> itemSummaryMap = new HashMap<SalesItem, KTSItemSummary>();
        LinkedHashSet<SalesItemSummary> summaries = new LinkedHashSet<SalesItemSummary>();
        for (KTSDocket docket : dockets) {
            for (SummaryLine<?> summaryLine : docket.getSummaryLines()) {
                ArrayList<SummaryItemLine> itemLines = new ArrayList<SummaryItemLine>();
                if (summaryLine instanceof SummaryItemLine) {
                    itemLines.add((SummaryItemLine)summaryLine);
                } else if (summaryLine instanceof SummaryGroupLine) {
                    for (KTSLine child : summaryLine.getChildren()) {
                        itemLines.add((SummaryItemLine)child);
                    }
                }
                for (SummaryItemLine itemLine : itemLines) {
                    if (itemLine.isComplete() || !"ACTIVE".equals(itemLine.getItemState()) && !"MOVED".equals(itemLine.getItemState())) continue;
                    for (SalesItemSummary summary : itemLine.getSummaries()) {
                        this.addSummary(itemSummaryMap, summary, itemLine.getQuantity());
                    }
                }
            }
        }
        summaries.addAll(itemSummaryMap.values());
        return summaries;
    }

    private void addSummary(Map<SalesItem, KTSItemSummary> itemSummaryMap, SalesItemSummary summary, SalesQuantity salesQuantity) {
        SalesItem key = summary.getSalesItem();
        if (!itemSummaryMap.containsKey(key)) {
            for (SalesItem nextItem : itemSummaryMap.keySet()) {
                if (!nextItem.isEquivalentTo((SalesLineItem)key, true, true, false, true)) continue;
                key = nextItem;
                break;
            }
        }
        if (!itemSummaryMap.containsKey(key)) {
            itemSummaryMap.put(key, new KTSItemSummary(salesQuantity, summary));
        } else {
            KTSItemSummary aggregate = itemSummaryMap.get(key);
            aggregate.myQuantity = aggregate.myQuantity.add(salesQuantity);
        }
    }

    class KTSItemSummary
    extends SalesItemSummary {
        SalesQuantity myQuantity;

        KTSItemSummary(SalesQuantity qty, SalesItemSummary toCopy) {
            super(toCopy);
            this.myQuantity = qty;
            this.setShowComboName(false);
        }

        public SalesQuantity getTotalQuantity() {
            return this.myQuantity;
        }

        public SalesQuantity getTotalCommittedQuantity(String itemState) {
            return this.myQuantity;
        }

        public SalesQuantity getTotalCommittedQuantity(boolean isReprint, String itemState) {
            return this.myQuantity;
        }
    }
}

