/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.summary.pipes;

import au.com.ordermate.pipeline.AbstractPipe;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.printSummary.SalesItemSummaryGroup;
import utils.ktsmate.docket.line.KTSLine;
import utils.ktsmate.docket.line.SummaryGroupLine;
import utils.ktsmate.docket.line.SummaryItemLine;
import utils.ktsmate.summary.SalesItemSummaryGroupCollection;

public class KTSConverter
extends AbstractPipe<List<SalesItemSummaryGroupCollection<?>>, List<KTSLine>> {
    public KTSConverter() {
        super(AbstractPipe.castToGeneric(List.class), AbstractPipe.castToGeneric(List.class));
    }

    public List<KTSLine> doPump(List<SalesItemSummaryGroupCollection<?>> summaryGroups) {
        ArrayList<KTSLine> ktsLines = new ArrayList<KTSLine>();
        for (SalesItemSummaryGroupCollection<?> groupCollection : summaryGroups) {
            KTSLine<String> groupHeading = null;
            if (groupCollection.getGroupIdentifier() != null) {
                groupHeading = new KTSLine<String>(groupCollection.getGroupIdentifier().toString(), null);
                ktsLines.add(groupHeading);
            }
            for (SalesItemSummaryGroup summaryGroup : groupCollection.getSummaryGroups()) {
                if (summaryGroup.getSummariesSize() == 1) {
                    SalesItemSummary summary = summaryGroup.getSummary();
                    SummaryItemLine summaryLine = new SummaryItemLine(summary, "ACTIVE", summary.getTotalQuantity());
                    ktsLines.add(summaryLine);
                    continue;
                }
                SummaryGroupLine summaryLine = new SummaryGroupLine(summaryGroup, summaryGroup.getState(), summaryGroup.getQuantity(), null);
                ktsLines.add(summaryLine);
            }
        }
        return ktsLines;
    }
}

