/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.web;

import au.com.ordermate.gateway.Gateway;
import au.com.ordermate.gateway.GatewayNotifier;
import au.com.ordermate.gateway.GatewayProcessor;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.kts.KTSDocketData;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.misc.resource.ConfigSmallImageWrapper;
import ordermate.webresource.tpx.TPXDocketSummary;
import utils.ktsmate.KTSMate;
import utils.ktsmate.docket.DefaultKTSListController;
import utils.ktsmate.docket.KTSDocket;
import utils.ktsmate.docket.KTSDocketEvent;
import utils.ktsmate.docket.data.KTSDocketDataProcessor;
import utils.ktsmate.web.WebFaceOverseer;

public class WebFaceModel
implements GatewayProcessor<TPXDocketSummary>,
GatewayNotifier<TPXDocketSummary> {
    private Gateway<TPXDocketSummary> gateway = new Gateway((GatewayProcessor)this, (GatewayNotifier)this);
    private List<TPXDocketSummary> upNext = new ArrayList<TPXDocketSummary>();
    private List<TPXDocketSummary> nowReady = new ArrayList<TPXDocketSummary>();
    private List<TPXDocketSummary> onHold = new ArrayList<TPXDocketSummary>();
    private Map<Long, ConfigSmallImageWrapper> imagesMap = new HashMap<Long, ConfigSmallImageWrapper>();
    private BufferedImage missingIcon = null;
    private static final long ONE_SECOND = 1000L;

    WebFaceModel() {
        this.gateway.startService();
    }

    public Gateway<TPXDocketSummary> getGateway() {
        return this.gateway;
    }

    public List<Long> getImageKeys() {
        return new ArrayList<Long>(this.imagesMap.keySet());
    }

    public boolean checkDocketExists(TPXDocketSummary dkt) {
        return this.upNext.contains(dkt) || this.nowReady.contains(dkt) || this.onHold.contains(dkt);
    }

    public void findAndRemoveDocketFromAll(TPXDocketSummary dkt) {
        if (this.upNext.contains(dkt)) {
            this.upNext.remove(dkt);
        }
        if (this.nowReady.contains(dkt)) {
            this.nowReady.remove(dkt);
        }
        if (this.onHold.contains(dkt)) {
            this.onHold.remove(dkt);
        }
    }

    private void refreshDocketData(List<TPXDocketSummary> dataList, KTSDocketState state) throws Exception {
        DefaultKTSListController listController = KTSMate.getListController();
        KTSDocketDataProcessor dktProcessor = new KTSDocketDataProcessor();
        long stale = System.currentTimeMillis() - (long)KTSMate.getLocalPrinter().getWebNowReadyTimeout() * 1000L;
        for (KTSDocket docket : listController.getDocketList(state)) {
            KTSDocketEvent lastEvent;
            if (KTSDocketState.Bump.equals((Object)state) && (lastEvent = docket.getLastEvent()).getTime() < stale || docket.getSalesAccountDocket() == null) continue;
            KTSDocketData data = (KTSDocketData)PersistenceManager.getObject(KTSDocketData.class, (String)Query.select(KTSDocketData.class).equals(KTSDocketData.Properties.SALES_ACCOUNT_DOCKET, (Object)docket.getSalesAccountDocket()).limit(1).toString(), null);
            dktProcessor.fillData(docket, data);
            TPXDocketSummary summary = new TPXDocketSummary(data);
            if (!this.checkDocketExists(summary)) {
                dataList.add(summary);
                OrderMate.LOG.info("Unsynced Docket ID " + summary.getDocketId() + " Added To Customer Order Display");
                continue;
            }
            if (dataList.contains(summary)) continue;
            this.findAndRemoveDocketFromAll(summary);
            dataList.add(summary);
            OrderMate.LOG.info("Resynced Docket ID: " + summary.getDocketId());
        }
    }

    public void refreshDockets() {
        try {
            this.refreshDocketData(this.upNext, KTSDocketState.Live);
            this.refreshDocketData(this.onHold, KTSDocketState.Hold);
            this.refreshDocketData(this.nowReady, KTSDocketState.Bump);
        }
        catch (Exception ex) {
            OrderMate.LOG.info(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TPXDocketSummary> getNowReady() {
        List<TPXDocketSummary> list = this.nowReady;
        synchronized (list) {
            return new ArrayList<TPXDocketSummary>(this.nowReady);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TPXDocketSummary> getUpNext() {
        List<TPXDocketSummary> list = this.upNext;
        synchronized (list) {
            return new ArrayList<TPXDocketSummary>(this.upNext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TPXDocketSummary> getOnHold() {
        List<TPXDocketSummary> list = this.onHold;
        synchronized (list) {
            return new ArrayList<TPXDocketSummary>(this.onHold);
        }
    }

    public void notifyProcess(TPXDocketSummary processedValue, boolean processSuccessful) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processIncoming(TPXDocketSummary toProcess) {
        List<TPXDocketSummary> list = this.nowReady;
        synchronized (list) {
            if (this.nowReady.contains(toProcess)) {
                this.nowReady.remove(toProcess);
            }
        }
        list = this.upNext;
        synchronized (list) {
            if (this.upNext.contains(toProcess)) {
                this.upNext.remove(toProcess);
            }
        }
        list = this.onHold;
        synchronized (list) {
            if (this.onHold.contains(toProcess)) {
                this.onHold.remove(toProcess);
            }
        }
        if (KTSDocketState.Live.equals((Object)toProcess.getState())) {
            list = this.upNext;
            synchronized (list) {
                this.upNext.add(toProcess);
            }
            return true;
        }
        if (KTSDocketState.Bump.equals((Object)toProcess.getState())) {
            list = this.nowReady;
            synchronized (list) {
                this.nowReady.add(toProcess);
            }
            return true;
        }
        if (KTSDocketState.Hold.equals((Object)toProcess.getState())) {
            list = this.onHold;
            synchronized (list) {
                this.onHold.add(toProcess);
            }
            return true;
        }
        OrderMate.LOG.info("Docket has no state, could not process.");
        return false;
    }

    public ConfigSmallImageWrapper getNewImage(TPXDocketSummary docket) {
        if (this.imagesMap.containsKey(docket.getCustomerId())) {
            return this.imagesMap.get(docket.getCustomerId());
        }
        ConfigSmallImageWrapper toReturn = WebFaceOverseer.getInstance().getWorker().getImageForDocket(docket);
        if (toReturn.getImage() == null) {
            this.loadMissingIcon();
            toReturn.setImage((Image)this.missingIcon);
        }
        this.imagesMap.put(toReturn.getCustomerId(), toReturn);
        return toReturn;
    }

    private void loadMissingIcon() {
        if (this.missingIcon == null) {
            try {
                ImageIcon img = IconLoader.get((String)"/waitermate/guikit/images/missingCustomer.png");
                BufferedImage bImg = new BufferedImage(img.getIconWidth(), img.getIconHeight(), 1);
                Graphics2D graphics = bImg.createGraphics();
                graphics.drawImage(img.getImage(), 0, 0, null);
                this.missingIcon = bImg;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot resolve missing icon", (Throwable)ex);
            }
        }
    }

    public void removeImagesFor(List<Long> toRemove) {
        if (toRemove == null || toRemove.isEmpty()) {
            return;
        }
        for (Long next : toRemove) {
            this.imagesMap.remove(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkStaleDockets() {
        List<TPXDocketSummary> list = this.nowReady;
        synchronized (list) {
            ArrayList<TPXDocketSummary> toRemove = new ArrayList<TPXDocketSummary>();
            Date now = new Date();
            for (TPXDocketSummary docket : this.nowReady) {
                if (now.getTime() - docket.getModifiedDate() <= (long)docket.getNowReadyTimeout()) continue;
                toRemove.add(docket);
            }
            this.nowReady.removeAll(toRemove);
        }
    }
}

