/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.web;

import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.webresource.tpx.TPXDocketSummary;
import utils.ktsmate.web.WebFaceModel;
import utils.ktsmate.web.WebFaceWorker;

public class WebFaceOverseer {
    static WebFaceOverseer overseer;
    protected WebFaceModel model;
    protected WebFaceWorker worker;
    protected Timer timer;
    protected WebFaceTask task;
    protected long lastRunTime = System.currentTimeMillis() - 60000L;
    private int staleCount = 0;
    private static final int STALE_EXPIRY_CHECK = 5;
    public static final long REFRESH_INTERVAL = 3000L;
    public static final long DOCKET_REFRESH_INTERVAL = 30000L;
    private static final int DOCKET_TIME_IN_PAST = 3600000;

    WebFaceOverseer() {
        OrderMate.LOG.info("Creating webface overseer");
        this.init();
    }

    public static WebFaceOverseer getInstance() {
        if (overseer == null) {
            overseer = new WebFaceOverseer();
        }
        return overseer;
    }

    protected void init() {
        this.model = new WebFaceModel();
        this.timer = new Timer("TPX Web Face Worker");
        this.lastRunTime = System.currentTimeMillis() - 3600000L;
        this.respawnWorker();
    }

    public WebFaceModel getModel() {
        return this.model;
    }

    public WebFaceWorker getWorker() {
        return this.worker;
    }

    public void respawnWorker() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.task != null) {
            this.task.cancel();
        }
        this.timer = null;
        this.worker = null;
        this.task = null;
        this.timer = new Timer("TPX Web Face Worker");
        this.worker = new WebFaceWorker();
        this.task = new WebFaceTask();
        this.timer.scheduleAtFixedRate((TimerTask)this.task, 0L, 3000L);
    }

    class WebFaceTask
    extends TimerTask {
        WebFaceTask() {
        }

        @Override
        public void run() {
            long newRunTime = System.currentTimeMillis();
            try {
                for (TPXDocketSummary docket : WebFaceOverseer.this.worker.getNewDockets(WebFaceOverseer.this.lastRunTime)) {
                    WebFaceOverseer.this.model.getGateway().putIntoQueue((Object)docket);
                }
                WebFaceOverseer.this.lastRunTime = newRunTime;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot get dockets for WebFace worker", (Throwable)ex);
            }
            try {
                WebFaceOverseer.this.staleCount++;
                if (WebFaceOverseer.this.staleCount > 5) {
                    WebFaceOverseer.this.model.checkStaleDockets();
                    WebFaceOverseer.this.staleCount = 0;
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot expire stale dockets", (Throwable)ex);
            }
        }
    }
}

