/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.web;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.resource.ConfigSmallImage;
import ordermate.database.misc.resource.ConfigSmallImageWrapper;
import ordermate.integration.webservice.RestHelper;
import ordermate.webresource.tpx.TPXDocketSummary;
import ordermate.webresource.tpx.TPXDocketSummaryTool;
import utils.ktsmate.KTSMate;

public class WebFaceWorker {
    private TPXDocketSummaryTool tool = new TPXDocketSummaryTool();
    private static final Integer connectTimeout = 5000;
    private static final Integer readTimeout = 5000;
    private static final String DOCKET_ENDPOINT = "/integration/tpx/dockets";
    private static final String IMAGE_ENDPOINT = "/integration/tpx/customerimage";
    private static final String HTTP = "http://";
    private static final String TPX_ID = "tpxId";
    private static final String MOD_SINCE = "modifiedSince";
    private static final String CUST_ID = "customerId";
    private static final String PORT = ":8090";
    private static final int MAX_IMAGE_SIZE = 64000;
    private String serverMateIP = Terminal.getServerMateTerminal().getIPAddress();
    private String getDockets = "http://" + this.serverMateIP + ":8090" + "/integration/tpx/dockets";
    private String getImages = "http://" + this.serverMateIP + ":8090" + "/integration/tpx/customerimage";
    private WebResource docketsClient;
    private WebResource imageDataClient;

    WebFaceWorker() {
    }

    public List<TPXDocketSummary> getNewDockets(long timeSinceLastRun) {
        List<TPXDocketSummary> newDockets = this.getDocketList(timeSinceLastRun);
        return newDockets != null ? newDockets : Collections.emptyList();
    }

    public ConfigSmallImageWrapper getImageForDocket(TPXDocketSummary docket) {
        byte[] imageData;
        if (docket.getCustomerId() != null && (imageData = this.getCustomerImageData(docket.getCustomerId())) != null) {
            ConfigSmallImageWrapper imageToReturn = new ConfigSmallImageWrapper(this.tool.reconstructImage(imageData, docket.getCustomerName()), docket.getCustomerId());
            return imageToReturn;
        }
        return new ConfigSmallImageWrapper(new ConfigSmallImage(""), docket.getCustomerId());
    }

    private List<TPXDocketSummary> getDocketList(long timeSinceLastRun) {
        WebResource wr;
        RestHelper rest = new RestHelper();
        if (this.docketsClient == null) {
            wr = rest.getResource(this.getDockets, connectTimeout, readTimeout);
            this.docketsClient = wr = rest.addParameter(wr, TPX_ID, KTSMate.getLocalPrinter().getID().toString());
        }
        wr = rest.addParameter(this.docketsClient, MOD_SINCE, String.valueOf(timeSinceLastRun));
        String dockets = (String)wr.get(String.class);
        return this.tool.unmarshal(dockets);
    }

    private byte[] getCustomerImageData(Long customerId) {
        RestHelper rest = new RestHelper();
        if (this.imageDataClient == null) {
            this.imageDataClient = rest.getResource(this.getImages, connectTimeout, readTimeout);
        }
        WebResource wr = rest.addParameter(this.imageDataClient, CUST_ID, String.valueOf(customerId));
        byte[] imageData = new byte[64000];
        ClientResponse cr = (ClientResponse)wr.get(ClientResponse.class);
        try {
            InputStream input = cr.getEntityInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int nextByte = input.read();
            while (nextByte != -1) {
                bout.write(nextByte);
                nextByte = input.read();
            }
            bout.flush();
            imageData = bout.toByteArray();
        }
        catch (IOException e) {
            OrderMate.LOG.error("Could not read image data from web service.", (Throwable)e);
        }
        return imageData;
    }
}

