/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.web.account;

import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import ordermate.OrderMate;
import ordermate.database.workflow.AccountRedemptionResultStringifier;
import ordermate.database.workflow.WorkflowAccountScanRedemptionResult;
import ordermate.services.sales.WorkflowBarcodeExecutable;
import utils.ktsmate.KTSMate;
import utils.ktsmate.web.account.ui.ScanBarcodePage;

class AccountBarcodeHandler {
    private final String barcode;
    private final ScanBarcodePage page;
    private volatile boolean interrupted = false;

    AccountBarcodeHandler(String barcode, ScanBarcodePage thePage) {
        this.barcode = barcode;
        this.page = thePage;
    }

    void interrupt() {
        this.interrupted = true;
    }

    void handleBarcode() {
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                if (AccountBarcodeHandler.this.interrupted) {
                    return;
                }
                AccountBarcodeHandler.this.page.updateInstructions("Scanned...", "Processing...");
                WorkflowAccountScanRedemptionResult response = (WorkflowAccountScanRedemptionResult)PersistenceManager.getServerConnection().runSync((Executable)new WorkflowBarcodeExecutable(AccountBarcodeHandler.this.barcode, KTSMate.getLocalPrinter().getLabel()));
                OrderMate.LOG.info("Scanned barcode " + AccountBarcodeHandler.this.barcode + " got " + response);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (AccountBarcodeHandler.this.interrupted) {
                    return;
                }
                AccountRedemptionResultStringifier resultStringifier = new AccountRedemptionResultStringifier(response);
                AccountBarcodeHandler.this.page.updateInstructions(resultStringifier.getTitle(), resultStringifier.getInformationMessage());
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (AccountBarcodeHandler.this.interrupted) {
                    return;
                }
                AccountBarcodeHandler.this.page.updateInstructions("Welcome!", "Please scan the barcode on your receipt.");
            }
        };
        new Thread(toRun).start();
    }
}

