/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.web.account;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObjectI;
import com.vaadin.annotations.Push;
import com.vaadin.server.Page;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import ordermate.database.config.ConfigStyleSheet;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import utils.ktsmate.KTSMate;
import utils.ktsmate.web.account.AccountBarcodeHandler;
import utils.ktsmate.web.account.ui.ScanBarcodePage;

@Push
public class AccountBarcodeUI
extends UI {
    private ScanBarcodePage barcodePanel;
    private AccountBarcodeHandler handler;

    protected void init(VaadinRequest request) {
        if (this.barcodePanel == null) {
            this.barcodePanel = new ScanBarcodePage();
            this.barcodePanel.gotBarcode.connect((Object)this, "gotBarcode");
            this.setContent((Component)this.barcodePanel);
            KTSDocketPrinter freshPrinter = (KTSDocketPrinter)PersistenceManager.reacquire((PersistentObjectI)KTSMate.getLocalPrinter());
            ConfigStyleSheet stylesheet = freshPrinter.getRedemptionStyleSheet();
            if (stylesheet != null) {
                Page.getCurrent().getStyles().add(stylesheet.getCss());
            }
        }
    }

    public void detach() {
        this.barcodePanel.gotBarcode.disconnect((Object)this);
        this.barcodePanel = null;
        super.detach();
    }

    public void gotBarcode(String barcodeEntered) {
        if (this.handler != null) {
            this.handler.interrupt();
        }
        this.handler = new AccountBarcodeHandler(barcodeEntered, this.barcodePanel);
        this.handler.handleBarcode();
    }
}

