/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.web.account.ui;

import com.vaadin.event.FieldEvents;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.UIDetachedException;
import ordermate.OrderMate;
import ordermate.signals.Signal;
import ordermate.signals.ThreadLocalSignal;
import utils.ktsmate.web.account.ui.ScanBarcodeInstructions;

public class ScanBarcodePage
extends CssLayout
implements FieldEvents.TextChangeListener {
    private ScanBarcodeInstructions instructions;
    private TextField inputField;
    public final Signal<String, ?, ?, ?, ?> gotBarcode = new ThreadLocalSignal(new Class[]{String.class});

    public ScanBarcodePage() {
        this.setupComponents();
    }

    public String getCss(Component toStyle) {
        if (this.inputField == toStyle) {
            return "background: transparent; border: none; color: transparent;";
        }
        return super.getCss(toStyle);
    }

    private void setupComponents() {
        this.inputField = new TextField();
        this.inputField.setId("barcode_input");
        this.inputField.addTextChangeListener((FieldEvents.TextChangeListener)this);
        this.inputField.setImmediate(true);
        this.instructions = new ScanBarcodeInstructions();
        this.addComponent((Component)this.instructions);
        this.addComponent((Component)this.inputField);
        this.inputField.addBlurListener(new FieldEvents.BlurListener(){

            public void blur(FieldEvents.BlurEvent event) {
                UI.getCurrent().setFocusedComponent((Component.Focusable)ScanBarcodePage.this.inputField);
            }
        });
        UI.getCurrent().setFocusedComponent((Component.Focusable)this.inputField);
    }

    public void textChange(FieldEvents.TextChangeEvent event) {
        OrderMate.LOG.info("Text received:" + event.getText());
        this.inputField.setEnabled(false);
        String value = event.getText();
        if (value != null && !(value = value.trim()).isEmpty()) {
            this.handleBarcodeScanned(value);
        }
        this.getUI().access(new Runnable(){

            @Override
            public void run() {
                ScanBarcodePage.this.inputField.setValue("");
            }
        });
        this.inputField.setEnabled(true);
        UI.getCurrent().setFocusedComponent((Component.Focusable)this.inputField);
    }

    private void handleBarcodeScanned(String value) {
        this.gotBarcode.emit((Object)value);
    }

    public void updateInstructions(final String newTitle, final String newInstructions) {
        try {
            if (!this.isAttached()) {
                OrderMate.LOG.warn("UI detached, attempting to re-attach.");
                this.attach();
            }
            this.getUI().access(new Runnable(){

                @Override
                public void run() {
                    ScanBarcodePage.this.instructions.setTitleAndInstructions(newTitle, newInstructions);
                }
            });
        }
        catch (UIDetachedException ex) {
            OrderMate.LOG.error("Cannot update UI Instructions, detached", (Throwable)ex);
        }
    }

    public void reset() {
        this.instructions.setTitleAndInstructions("Welcome", "Please Scan your Barcode");
    }
}

