/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.web.ui;

import au.com.ordermate.persistence.PersistenceManager;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.Label;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.sales.Account;
import ordermate.webresource.tpx.TPXDocketSummary;

public class WebFaceRenderer
extends CssLayout {
    private static DateFormat dateFormat = new SimpleDateFormat("h:mm a");
    private float DEFAULT_WIDTH = 200.0f;
    private float DEFAULT_HEIGHT = 200.0f;
    private int DEFAULT_MILLISECONDS = 1000;
    private TPXDocketSummary summary;
    private Embedded facePic;
    private Label descLabel;

    public WebFaceRenderer(String style, TPXDocketSummary summary) {
        KTSDocketPrinter ktsPrinter = (KTSDocketPrinter)PersistenceManager.getByID((long)summary.getPrinterId(), KTSDocketPrinter.class);
        this.addStyleName(style);
        if (ktsPrinter.getWebShowIcons()) {
            this.facePic = new Embedded();
            this.facePic.setWidth(this.DEFAULT_WIDTH, Sizeable.Unit.PIXELS);
            this.facePic.setHeight(this.DEFAULT_HEIGHT, Sizeable.Unit.PIXELS);
            this.addComponent((Component)this.facePic);
        }
        this.descLabel = new Label("<b>No data</b>", ContentMode.HTML);
        this.descLabel.addStyleName("docket_data");
        this.addComponent((Component)this.descLabel);
        this.setSizeUndefined();
        summary.setNowReadyTimeout(ktsPrinter.getWebNowReadyTimeout() * this.DEFAULT_MILLISECONDS);
        this.setTPXSummary(summary, ktsPrinter);
    }

    public Label getDescLabel() {
        return this.descLabel;
    }

    public Embedded getFacePic() {
        return this.facePic;
    }

    private StringBuilder appendDivToString(StringBuilder str, String divClass, String value, boolean enabled) {
        if (enabled) {
            str.append("<div class=\"" + divClass + "\">" + value + "</div>\n");
        }
        return str;
    }

    private StringBuilder appendDivToString(StringBuilder str, String divClass, long value, boolean enabled) {
        if (enabled) {
            str.append("<div class=\"" + divClass + "\">" + value + "</div>\n");
        }
        return str;
    }

    public void setTPXSummary(TPXDocketSummary aSummary, KTSDocketPrinter ktsPrinter) {
        this.summary = aSummary;
        StringBuilder b = new StringBuilder();
        b = this.summary.getShortenedCustomerName() != null && !"".equals(this.summary.getShortenedCustomerName()) ? this.appendDivToString(b, "name known", this.summary.getShortenedCustomerName(), ktsPrinter.getWebShowCustomerNames()) : this.appendDivToString(b, "name unknown", "", ktsPrinter.getWebShowCustomerNames());
        Account acc = (Account)PersistenceManager.getByID((long)this.summary.getAccountId(), Account.class);
        b = this.appendDivToString(b, "orderno", acc.getOrderNumber(), ktsPrinter.getWebShowOrderNumber());
        b = this.appendDivToString(b, "ordertime", dateFormat.format(this.summary.getCreatedDate()), ktsPrinter.getWebShowOrderTime());
        this.descLabel.setValue(b.toString());
    }

    public TPXDocketSummary getTPXSummary() {
        return this.summary;
    }

    public void setIcon(Resource resource) {
        if (this.facePic != null) {
            this.facePic.setSource(resource);
        }
    }

    public TPXDocketSummary getSummary() {
        return this.summary;
    }
}

