/*
 * Decompiled with CFR 0.152.
 */
package utils.ktsmate.web.ui;

import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageFormat;
import au.com.ordermate.util.image.ImageHelper;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.StreamResource;
import com.vaadin.server.VaadinSession;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import javax.swing.ImageIcon;
import ordermate.OrderMate;
import ordermate.database.misc.resource.ConfigSmallImageWrapper;
import ordermate.webresource.tpx.TPXDocketSummary;
import utils.ktsmate.web.WebFaceModel;
import utils.ktsmate.web.WebFaceOverseer;
import utils.ktsmate.web.ui.WebFaceRenderer;

class WebFaceUI
extends CssLayout {
    private String REND_UP_NEXT = "webface";
    private String REND_NOW_READY = "webfacenowready";
    private WebFaceModel model;
    private Timer timer;
    private Timer docketRefreshTimer;
    private WebFaceUpdateTask task;
    private Layout nowReady;
    private Layout upNext;
    private Layout onHold;
    private Layout header;
    private List<WebFaceRenderer> facesNowReady = new ArrayList<WebFaceRenderer>();
    private List<WebFaceRenderer> facesUpNext = new ArrayList<WebFaceRenderer>();
    private List<WebFaceRenderer> facesOnHold = new ArrayList<WebFaceRenderer>();
    private ImageHelper helper;
    private StreamResource missingResource;
    private Semaphore updateLatch = new Semaphore(1);
    private static final int MAX_DOCKET_COUNT = 10;

    WebFaceUI() {
        this.helper = new ImageHelper();
        OrderMate.LOG.info("Creating new WebFace");
        this.model = WebFaceOverseer.getInstance().getModel();
        this.facesNowReady = new ArrayList<WebFaceRenderer>();
        this.facesUpNext = new ArrayList<WebFaceRenderer>();
        this.facesOnHold = new ArrayList<WebFaceRenderer>();
        this.task = new WebFaceUpdateTask();
        this.timer = new Timer("Web Face UI Timer", true);
        this.docketRefreshTimer = new Timer("Web Face Docket Refresh Timer");
        this.setupComponents();
        this.setCSSNames();
        this.timer.schedule((TimerTask)this.task, 2000L, 3000L);
        this.docketRefreshTimer.schedule((TimerTask)new WebFaceDocketRefreshTask(), 2000L, 30000L);
    }

    private void setCSSNames() {
        this.addStyleName("tpxui");
        this.header.addStyleName("header");
        this.nowReady.addStyleName("nowready");
        this.upNext.addStyleName("upnext");
    }

    private void setupComponents() {
        this.setupHeader();
        this.setupNowReady();
        this.setupUpNext();
    }

    private void setupHeader() {
        this.header = new CssLayout();
        Label headerLabel = new Label("Next InQ");
        headerLabel.setSizeUndefined();
        headerLabel.addStyleName("header");
        this.header.addComponent((Component)headerLabel);
        this.addComponent((Component)this.header);
    }

    private void setupNowReady() {
        Label nowReadyHeader = new Label("Now Ready");
        nowReadyHeader.setSizeUndefined();
        nowReadyHeader.addStyleName("nowready");
        this.nowReady = new CssLayout();
        for (WebFaceRenderer face : this.facesNowReady) {
            this.nowReady.addComponent((Component)face);
        }
        this.addComponent((Component)nowReadyHeader);
        this.addComponent((Component)this.nowReady);
    }

    private void setupUpNext() {
        Label upNextHeader = new Label("Up Next");
        upNextHeader.setSizeUndefined();
        upNextHeader.addStyleName("upnext");
        this.upNext = new CssLayout();
        this.upNext.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        for (WebFaceRenderer face : this.facesUpNext) {
            this.upNext.addComponent((Component)face);
        }
        this.addComponent((Component)upNextHeader);
        this.addComponent((Component)this.upNext);
    }

    private void setupOnHold() {
        if (this.onHold == null) {
            this.onHold = new VerticalLayout();
        }
        this.onHold.addComponent((Component)new Label("ON HOLD"));
        for (WebFaceRenderer face : this.facesOnHold) {
            this.onHold.addComponent((Component)face);
        }
        this.addComponent((Component)this.onHold);
    }

    private void refreshFaces() {
        this.convertDocketsToRenderers(this.model.getNowReady(), this.REND_NOW_READY, this.facesNowReady);
        this.convertDocketsToRenderers(this.model.getOnHold(), this.REND_UP_NEXT, this.facesOnHold);
        this.convertDocketsToRenderers(this.model.getUpNext(), this.REND_UP_NEXT, this.facesUpNext);
        this.nowReady.removeAllComponents();
        this.upNext.removeAllComponents();
        for (WebFaceRenderer renderer : this.facesNowReady) {
            this.nowReady.addComponent((Component)renderer);
        }
        for (WebFaceRenderer renderer : this.facesUpNext) {
            this.upNext.addComponent((Component)renderer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNewImages() {
        if (!this.updateLatch.tryAcquire()) {
            OrderMate.LOG.info("Cannot acquire latch, in use");
            return;
        }
        try {
            ArrayList<WebFaceRenderer> allRenderers = new ArrayList<WebFaceRenderer>(this.facesNowReady);
            allRenderers.addAll(this.facesUpNext);
            allRenderers.addAll(this.facesOnHold);
            for (WebFaceRenderer renderer : allRenderers) {
                ConfigSmallImageWrapper toRender;
                if (renderer.getIcon() != null) continue;
                StreamResource resource = null;
                if (renderer.getTPXSummary().getCustomerId() != null && (toRender = this.model.getNewImage(renderer.getTPXSummary())) != null && toRender.getImage() != null) {
                    Image image = this.helper.roundCorners((Image)toRender.getImage(), (int)(toRender.getImageWidth() / 2L));
                    toRender.setImage(this.helper.cropImageToOneOneAspectRatio(image));
                    resource = this.convertImageToStreamResource(toRender);
                }
                if (resource == null) {
                    resource = this.getMissingImage();
                }
                if (resource == null) continue;
                renderer.setIcon((Resource)resource);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot update renderers", (Throwable)ex);
        }
        finally {
            this.updateLatch.release();
        }
    }

    private StreamResource getMissingImage() {
        ImageIcon icon;
        if (this.missingResource == null && (icon = IconLoader.get((String)"/waitermate/guikit/images/missingCustomer.png")) != null && icon.getImage() != null) {
            Image img = this.helper.cropImageToOneOneAspectRatio(icon.getImage());
            this.helper.roundCorners(img, img.getWidth(null) / 2);
            this.missingResource = new StreamResource(this.convertImageToStreamSource(img, img.getWidth(null), img.getHeight(null)), "MissingCustomer.png");
        }
        return this.missingResource;
    }

    private void removeExpiredImages() {
        ArrayList<WebFaceRenderer> allRenderers = new ArrayList<WebFaceRenderer>(this.facesNowReady);
        allRenderers.addAll(this.facesUpNext);
        allRenderers.addAll(this.facesOnHold);
        ArrayList<Long> activeCustomerIds = new ArrayList<Long>();
        for (WebFaceRenderer renderer : allRenderers) {
            activeCustomerIds.add(renderer.getTPXSummary().getCustomerId());
        }
        ArrayList<Long> toRemove = new ArrayList<Long>();
        for (Long key : this.model.getImageKeys()) {
            if (activeCustomerIds.contains(key)) continue;
            toRemove.add(key);
        }
        this.model.removeImagesFor(toRemove);
    }

    private StreamResource.StreamSource convertImageToStreamSource(Image image, int width, int height) {
        BufferedImage bImg = new BufferedImage(width, height, 1);
        Graphics2D graphics = bImg.createGraphics();
        graphics.drawImage(image, 0, 0, null);
        final byte[] arr = this.helper.shrinkToByteSize((Image)bImg, Integer.MAX_VALUE, ImageFormat.JPG);
        return new StreamResource.StreamSource(){

            public InputStream getStream() {
                return new ByteArrayInputStream(arr);
            }
        };
    }

    private StreamResource convertImageToStreamResource(ConfigSmallImageWrapper img) {
        Image image = this.helper.roundCorners((Image)img.getImage(), (int)(img.getImageWidth() / 2L));
        StreamResource.StreamSource src = this.convertImageToStreamSource(image, (int)img.getImageWidth(), (int)img.getImageHeight());
        StreamResource toReturn = new StreamResource(src, img.getCustomerId() + "-" + System.currentTimeMillis() % 1000L + ".jpg");
        return toReturn;
    }

    private void convertDocketsToRenderers(List<TPXDocketSummary> summaries, String style, List<WebFaceRenderer> rendererList) {
        ArrayList<WebFaceRenderer> current = new ArrayList<WebFaceRenderer>(rendererList);
        rendererList.clear();
        for (TPXDocketSummary summary : summaries) {
            if (summary.getAccountId() == null) continue;
            WebFaceRenderer renderer = null;
            for (WebFaceRenderer nextCurrent : current) {
                if (!nextCurrent.getSummary().getAccountId().equals(summary.getAccountId())) continue;
                renderer = nextCurrent;
                break;
            }
            if (renderer == null) {
                renderer = new WebFaceRenderer(style, summary);
            }
            rendererList.add(renderer);
        }
    }

    class WebFaceDocketRefreshTask
    extends TimerTask {
        WebFaceDocketRefreshTask() {
        }

        @Override
        public void run() {
            if (WebFaceUI.this.getUI() == null) {
                OrderMate.LOG.info("Customer Order Display Refresh Via Timer not updating, no ui " + Thread.currentThread().getId());
            } else {
                OrderMate.LOG.info("Last heartbeat:" + WebFaceUI.this.getUI().getLastHeartbeatTimestamp());
                OrderMate.LOG.info("Customer Order Display Refresh Via Timer " + Thread.currentThread().getId());
                WebFaceOverseer.getInstance().getModel().refreshDockets();
            }
        }
    }

    class WebFaceUpdateTask
    extends TimerTask
    implements ClientConnector.DetachListener {
        boolean run = true;

        WebFaceUpdateTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.run) {
                return;
            }
            Lock lock = null;
            try {
                UI ui = WebFaceUI.this.getUI();
                if (ui != null) {
                    ui.addDetachListener((ClientConnector.DetachListener)this);
                    VaadinSession sesh = ui.getSession();
                    if (sesh != null) {
                        lock = sesh.getLockInstance();
                    }
                    if (lock != null) {
                        lock.lock();
                        WebFaceUI.this.refreshFaces();
                        WebFaceUI.this.updateNewImages();
                        WebFaceUI.this.removeExpiredImages();
                    }
                } else {
                    OrderMate.LOG.info("UI Disappeared");
                }
            }
            catch (Exception e) {
                OrderMate.LOG.error("Could not acquire lock to update Vaadin GUI.", (Throwable)e);
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }

        public void detach(ClientConnector.DetachEvent event) {
            OrderMate.LOG.info("Detaching UI");
            WebFaceUI.this.timer.cancel();
            WebFaceUI.this.docketRefreshTimer.cancel();
            this.run = false;
        }
    }
}

