/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import waitermate.guikit.NavBar;
import waitermate.guikit.ScreenRegistry;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public abstract class AbstractScreen {
    private static final ScreenRegistry registry = new ScreenRegistry();
    private static final double DIALOG_FACTOR = 0.85;
    public final Signal displayed = Signals.createSignal();
    public final Signal hidden = Signals.createSignal();
    private PopupWindow popupWindow;
    private boolean displayCalled = false;

    protected AbstractScreen() {
        registry.registerScreen(this);
    }

    protected Dimension getDialogDisplayFactor() {
        return ScreenResource.getMaxDialogDimension();
    }

    public static void updateComponentTreeUIs() {
        registry.updateComponentTreeUIs();
    }

    public void display() {
        this.display(this.isFullScreen());
    }

    public void display(boolean fullScreen) {
        if (!fullScreen) {
            if (!this.isDisplaying() && !this.displayCalled) {
                this.displayCalled = true;
                this.popupWindow = new PopupWindow(this.getNavBar(), false);
                this.popupWindow.setBaseDialog(true);
                this.popupWindow.visibleSignal.connect((Object)this, "gotPopupVisible");
                this.popupWindow.setComponent(this.getMainArea());
                if (this.getDialogDisplayFactor() != null) {
                    this.getMainArea().setPreferredSize(this.getDialogDisplayFactor());
                }
                this.setUp();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractScreen.this.displayCalled = false;
                        if (AbstractScreen.this.popupWindow != null) {
                            Dialogs.displayDialog(AbstractScreen.this.popupWindow, null, null);
                        } else {
                            OrderMate.LOG.warn(AbstractScreen.this.getName() + " attempted to show a NULL popup window.");
                        }
                    }
                });
            }
        } else {
            this.getMainArea().setPreferredSize(null);
            ScreenResource.setScreen(this);
        }
    }

    public boolean isFullScreen() {
        return this.popupWindow == null;
    }

    public boolean isDisplaying() {
        return ScreenResource.getScreen() == this || this.popupWindow != null && this.popupWindow.isShowing();
    }

    public abstract JComponent getMainArea();

    public abstract NavBar getNavBar();

    public boolean hasNavBar() {
        return true;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return this.getName();
    }

    public void setUp() {
        this.displayed.emit();
    }

    public void tearDown() {
        if (this.popupWindow != null) {
            this.popupWindow.setComponent(null);
            this.popupWindow.visibleSignal.disconnect((Object)this);
            this.popupWindow.disconnectNavBar();
            if (this.popupWindow.isShowing()) {
                ScreenResource.stopWindow(this.popupWindow);
            }
            this.popupWindow = null;
        }
        this.hidden.emit();
    }

    public final Rectangle getBounds() {
        Rectangle bounds = this.getMainArea().getBounds();
        Rectangle navBounds = this.getNavBar().getBounds();
        return new Rectangle(bounds.x, bounds.y, bounds.width + navBounds.width, bounds.height + navBounds.height);
    }

    public final Dimension getSize() {
        Dimension dimension = this.getMainArea().getSize();
        return new Dimension(dimension.width, dimension.height + this.getNavBar().getSize().height);
    }

    public final Point getLocationRelativeToRootPane() {
        Point compLocation = this.getMainArea().getLocation();
        compLocation.y += ScreenResource.getMenuHeight();
        return compLocation;
    }

    public void displose() {
    }

    public void gotPopupVisible(Boolean visible) {
        if (!visible.booleanValue()) {
            this.tearDown();
        }
    }
}

