/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import waitermate.guikit.AbstractScreen;
import waitermate.guikit.NavBar;

class ScreenRegistry {
    private WeakHashSet<AbstractScreen> screenSet = new WeakHashSet();

    ScreenRegistry() {
    }

    public final synchronized void registerScreen(AbstractScreen screen) {
        this.screenSet.add(screen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateComponentTreeUIs() {
        HashSet<AbstractScreen> currentScreenSet = null;
        ScreenRegistry screenRegistry = this;
        synchronized (screenRegistry) {
            currentScreenSet = new HashSet<AbstractScreen>(this.screenSet);
        }
        for (AbstractScreen screen : currentScreenSet) {
            JComponent mainArea = screen.getMainArea();
            NavBar nav = screen.getNavBar();
            if (mainArea != null) {
                SwingUtilities.updateComponentTreeUI(mainArea);
            }
            if (nav == null) continue;
            SwingUtilities.updateComponentTreeUI(nav);
        }
    }

    private static final class WeakHashSet<E>
    extends AbstractSet<E> {
        private final WeakHashMap<E, Object> decoratedMap = new WeakHashMap();

        private WeakHashSet() {
        }

        @Override
        public boolean add(E e) {
            return this.decoratedMap.put(e, null) == null;
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            boolean setChanged = false;
            for (E screen : collection) {
                setChanged |= this.add(screen);
            }
            return setChanged;
        }

        @Override
        public void clear() {
            this.decoratedMap.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.decoratedMap.containsKey(o);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object obj : collection) {
                if (!this.contains(obj)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.decoratedMap.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return this.decoratedMap.keySet().iterator();
        }

        @Override
        public boolean remove(Object o) {
            return this.decoratedMap.remove(o) != null;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.decoratedMap.keySet().removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.decoratedMap.keySet().retainAll(c);
        }

        @Override
        public int size() {
            return this.decoratedMap.size();
        }

        @Override
        public Object[] toArray() {
            return this.decoratedMap.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.decoratedMap.keySet().toArray(a);
        }
    }
}

