/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.task.CompositeTask;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.OrderMate;
import ordermate.internationalization.Internationalization;
import ordermate.serverconnection.ConnectionManagerScreen;
import waitermate.guikit.NotificationManager;
import waitermate.guikit.ScreenResource;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.task.RestartWaitermateTask;

public class WaitermateConnectionPanel
extends JPanel
implements ActionListener,
ConnectionManagerScreen {
    private static final String EXIT_PIN = "1300667002";
    private JButton exitButton;
    private JLabel retryLabel;
    private boolean showing;
    private boolean allTasksStarted = false;
    private WaitAndRestartTask waitAndRestartTask;

    public WaitermateConnectionPanel() {
        this.setLayout((LayoutManager)new GraphPaperLayout(20, 20));
        JLabel messageLabel = new JLabel(Internationalization.getLiteralFor((String)"DISCONNECTED_FROM_SERVER"));
        Font currentFont = messageLabel.getFont();
        messageLabel.setFont(currentFont.deriveFont((float)(currentFont.getSize() + 4)));
        messageLabel.setHorizontalAlignment(0);
        this.add((Component)messageLabel, new Rectangle(1, 1, 18, 2));
        JLabel messageLabel2 = new JLabel(Internationalization.getLiteralFor((String)"WAITERMATE_WILL_ATTEMPT_TO_RECONNECT"));
        messageLabel2.setHorizontalAlignment(0);
        this.add((Component)messageLabel2, new Rectangle(1, 4, 18, 1));
        this.retryLabel = new JLabel();
        this.retryLabel.setHorizontalAlignment(0);
        this.add((Component)this.retryLabel, new Rectangle(1, 12, 18, 1));
        JLabel imageLabel = new JLabel(IconLoader.get((String)"/waitermate/guikit/images/reconnect.gif"));
        this.add((Component)imageLabel, new Rectangle(4, 8, 12, 4));
        this.exitButton = new JButton(Internationalization.getLiteralFor((String)"EXIT"));
        this.exitButton.setIcon(IconLoader.get((String)"/waitermate/guikit/images/exit.png"));
        this.exitButton.addActionListener(this);
        this.add((Component)this.exitButton, new Rectangle(7, 16, 6, 3));
        this.setSize(400, 400);
        CompositeTask.allTasksStarted.connect((Object)this, "setAllTasksStarted");
    }

    private void setAllTasksStarted() {
        this.allTasksStarted = true;
    }

    public void setNumRetries(String server, int numRetry) {
        String text = "Tried to connect to " + server + " " + numRetry + " times";
        this.retryLabel.setText(text);
    }

    public void showConnectionInterface() {
        if (!this.showing && this.allTasksStarted) {
            this.showing = true;
            ScreenResource.startModalWindow(this);
        }
    }

    public void hideConnectionInterface() {
        if (this.showing) {
            ScreenResource.stopWindow(this);
            this.showing = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.exitButton)) {
            String result = Dialogs.getPIN(false);
            if (result.equals(EXIT_PIN)) {
                OrderMate.LOG.warn("Exiting WaiterMate via reconnection dialog pin entry.");
                System.exit(0);
            } else if (!result.equals("\u0000")) {
                Dialogs.displayOkDialog(Internationalization.getLiteralFor((String)"INCORRECT_PIN_NR"), Internationalization.getLiteralFor((String)"INCORRECT_PIN"));
            }
        }
    }

    public void displayVersionWarningDialog(String serverVersion) {
        if (this.waitAndRestartTask == null) {
            this.waitAndRestartTask = new WaitAndRestartTask();
            Timer timer = new Timer();
            timer.schedule((TimerTask)this.waitAndRestartTask, 60000L);
            Dialogs.displayOkDialog(Internationalization.getLiteralFor((String)"SERVER_VERSION") + " " + serverVersion + " " + Internationalization.getLiteralFor((String)"DOES_NOT_MATCH_THIS_VERSION"), Internationalization.getLiteralFor((String)"SERVER_VERSION_MISMATCH"));
            this.waitAndRestartTask.run();
        }
    }

    public void connectedToServer(boolean isRedundant, String connectedServer) {
        NotificationManager.getInstance().notifyFailover.emit((Object)isRedundant, (Object)connectedServer);
    }

    class WaitAndRestartTask
    extends TimerTask {
        WaitAndRestartTask() {
        }

        @Override
        public void run() {
            try {
                new RestartWaitermateTask().runLocal();
            }
            catch (Exception e) {
                OrderMate.LOG.error("Could not restart waitermate, trying the direct approach");
                System.exit(0);
            }
        }
    }
}

