/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.actions;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.docketprocessor.DocketProcessor;
import ordermate.docketprocessor.ExternalPrintJob;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.dialogs.Dialogs;

public class PrintExternalDocketAction
extends BasicAction {
    private final String docketHref;

    public PrintExternalDocketAction(String yourDocketHref) {
        super(Internationalization.getLiteralFor((String)"PRINT_ONLINE_DOCKET"), (Icon)IconLoader.get((String)"/waitermate/images/externalDocket.png"));
        this.docketHref = yourDocketHref;
    }

    public void actionPerformed(ActionEvent e) {
        this.downloadAndPrint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadAndPrint() {
        String xml = null;
        BufferedReader reader = null;
        try {
            URL url = new URL(this.docketHref);
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder SB = new StringBuilder();
            String line = null;
            try {
                line = reader.readLine();
                while (line != null) {
                    SB.append(line).append("\n");
                    line = reader.readLine();
                }
                xml = SB.toString();
            }
            catch (IOException ex) {
                OrderMate.LOG.warn("Error with the incoming docket line.", (Throwable)ex);
            }
        }
        catch (MalformedURLException ex) {
            OrderMate.LOG.warn("Could not download docket from:" + this.docketHref, (Throwable)ex);
        }
        catch (IOException ex) {
            OrderMate.LOG.warn("Could not open url stream for:" + this.docketHref, (Throwable)ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.warn("Could not close off the url reader.", (Throwable)ex);
                }
            }
        }
        if (xml != null && !xml.isEmpty()) {
            List printers = Terminal.getLocalHost().getAvailableReceiptPrinters();
            if (!printers.isEmpty()) {
                try {
                    OrderMate.LOG.info("Attempting to print :\n" + xml);
                    DocketProcessor.printExternalDocket((ExternalPrintJob)new ExternalPrintJob(xml, (VirtualPrinter)printers.get(0)));
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Could not print the xml docket.", (Throwable)ex);
                }
            } else {
                Dialogs.displayOkDialog(Internationalization.getLiteralFor((String)"CANNOT_PRINT_OFF_THE_DOCKET_AS_NO_RECEIPT_PRINTERS_ON_TERMINAL"), Internationalization.getLiteralFor((String)"CANNOT_PRINT_DOCKET"));
            }
        } else {
            Dialogs.displayOkDialog(Internationalization.getLiteralFor((String)"THE_ONLINE_DOCKET_INFORMATION_COULD_NOT_BE_RETRIEVED"), Internationalization.getLiteralFor((String)"CANNOT_DOWNLOAD_DOCKET"));
        }
    }
}

