/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.animator;

import java.awt.Component;
import java.awt.Rectangle;
import org.jdesktop.animation.timing.TimingTarget;

public abstract class BoundsAnimator
implements TimingTarget {
    private final Component comp;
    private Rectangle start;
    private Rectangle end;

    public BoundsAnimator(Component toAnimate, Rectangle startingBounds, Rectangle endingBounds) {
        this.comp = toAnimate;
        if (endingBounds == null || startingBounds == null) {
            throw new IllegalArgumentException("Cannot have a null Rectangle for BoundAnimator");
        }
        this.start = startingBounds;
        this.end = endingBounds;
    }

    public void begin() {
        this.comp.setBounds(this.start);
    }

    public void end() {
        this.comp.setBounds(this.end);
    }

    public void repeat() {
    }

    public void setStartingBounds(Rectangle startingBounds) {
        if (startingBounds == null) {
            throw new IllegalArgumentException("Cannot have a null Rectangle for BoundAnimator");
        }
        this.start = startingBounds;
    }

    public void setEndingBounds(Rectangle endingBounds) {
        if (endingBounds == null) {
            throw new IllegalArgumentException("Cannot have a null Rectangle for BoundAnimator");
        }
        this.end = endingBounds;
    }

    public void timingEvent(float arg0) {
        this.comp.setBounds(this.calculateNewBounds(this.start, this.end, arg0));
    }

    protected abstract Rectangle calculateNewBounds(Rectangle var1, Rectangle var2, float var3);
}

