/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.components;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.Displayable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.gui.BorderUtils;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.scroll.renderer.DisplayableRenderer;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class AbstractSelectableDrawerPanel
extends JPanel {
    public final Signal selected;
    public final Signal changed = Signals.createSignal();
    private Class objectClazz;
    private RendererScrollPaneModel scrollPaneModel;
    JLabel title = new JLabel("<HTML><FONT SIZE='+1'>" + Internationalization.getLiteralFor((String)"SELECT_AN_OBJECT") + "</FONT></HTML>");

    protected abstract int getRowsPerPage();

    protected abstract int getMaxColumns();

    protected abstract List getObjectList();

    public AbstractSelectableDrawerPanel(Class objectClass) {
        this.selected = Signals.createSignal((Class)objectClass, (String)"selected");
    }

    void init(Class objectClass) {
        this.objectClazz = objectClass;
        JComponent bottomComp = this.getBottomComponent();
        int rows = 20;
        if (bottomComp != null) {
            rows = 22;
        }
        this.setLayout((LayoutManager)new GraphPaperLayout(1, rows));
        BorderUtils.addEmptyBorder((JComponent)this);
        this.add((Component)this.title, new Rectangle(0, 0, 1, 2));
        this.scrollPaneModel = new RendererScrollPaneModel(this.constructRenderer());
        this.add((Component)this.constructScrollPane(this.scrollPaneModel), new Rectangle(0, 2, 1, 18));
        this.setPreferredSize(this.getInitialSize());
        this.setData(this.getObjectList());
        if (bottomComp != null) {
            this.add((Component)bottomComp, new Rectangle(0, 19, 1, 2));
        }
    }

    protected JComponent getBottomComponent() {
        return null;
    }

    protected Renderer constructRenderer() {
        DisplayableRenderer displayableRenderer = new DisplayableRenderer();
        displayableRenderer.selected.connect((Object)this, "gotSelected");
        return displayableRenderer;
    }

    protected CustomScrollPane constructScrollPane(RendererScrollPaneModel model) {
        CustomScrollPane pane = new CustomScrollPane((CustomScrollPaneModel)model);
        pane.setColumns(this.getColumns());
        pane.setRowsPerPage(this.getRowsPerPage());
        pane.setOpaque(false);
        return pane;
    }

    protected RendererScrollPaneModel getModel() {
        return this.scrollPaneModel;
    }

    protected int getColumns() {
        int columnCount = 1 + (this.getObjectList().size() - 1) / this.getRowsPerPage();
        if (columnCount > this.getMaxColumns()) {
            return this.getMaxColumns();
        }
        return columnCount;
    }

    protected Dimension getInitialSize() {
        return new Dimension(200, 500);
    }

    private void setData(List objectList) {
        this.scrollPaneModel.removeAllObjects();
        this.scrollPaneModel.addObjects((Collection)objectList);
    }

    protected void clearSelection() {
        this.scrollPaneModel.clearSelection();
    }

    public void setTitle(String htmlTitle) {
        this.title.setText(htmlTitle);
    }

    public void gotSelected(Displayable displayable) {
        if (!this.objectClazz.isAssignableFrom(displayable.getClass())) {
            throw new IllegalArgumentException("Selected object is wrong type. Expected: " + this.objectClazz + "but got: " + displayable.getClass());
        }
        this.selected.emit((Object)displayable);
        this.changed.emit();
    }
}

