/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.components;

import au.com.ordermate.persistence.Displayable;
import java.util.ArrayList;
import java.util.List;
import ordermate.gui.button.CustomToggleButton;
import ordermate.gui.scroll.Renderer;
import ordermate.gui.scroll.RendererScrollPaneModel;
import ordermate.gui.scroll.renderer.DisplayableToggleRenderer;
import waitermate.guikit.components.DefaultSelectableDrawerPanel;

public class SelectableToggleDrawerPanel
extends DefaultSelectableDrawerPanel {
    protected List selectedObjectList = new ArrayList();
    private boolean isGrouped = false;

    public SelectableToggleDrawerPanel(List objectList, Class objectClass) {
        this(objectList, objectClass, false);
    }

    public SelectableToggleDrawerPanel(List objectList, Class objectClass, boolean grouped) {
        super(objectList, objectClass);
        this.isGrouped = grouped;
        this.init(objectClass);
    }

    @Override
    protected Renderer constructRenderer() {
        DisplayableToggleRenderer renderer = new DisplayableToggleRenderer(this.isGrouped);
        renderer.selected.connect((Object)this, "gotSelected");
        renderer.deselected.connect((Object)this, "gotDeselected");
        return renderer;
    }

    public List getSelectedObjects() {
        return this.selectedObjectList;
    }

    public void setSelectedObjects(List newSelectedObjects) {
        this.clearSelection();
        this.getComponents();
        this.selectedObjectList.addAll(newSelectedObjects);
        RendererScrollPaneModel model = this.getModel();
        for (Displayable dispObj : this.selectedObjectList) {
            CustomToggleButton button = (CustomToggleButton)model.getComponent(dispObj);
            button.setSelected(true);
        }
    }

    @Override
    public void gotSelected(Displayable displayableObject) {
        if (this.isGrouped) {
            this.selectedObjectList.clear();
        }
        this.selectedObjectList.add(displayableObject);
        this.changed.emit();
    }

    public void gotDeselected(Displayable displayableObject) {
        if (!this.selectedObjectList.remove(displayableObject)) {
            throw new IllegalStateException("Attempt to remove object from selected list when not present in list, " + displayableObject);
        }
        if (!this.isGrouped) {
            this.changed.emit();
        }
    }

    @Override
    public void clearSelection() {
        this.selectedObjectList.clear();
        this.getModel().clearSelection();
        ((DisplayableToggleRenderer)this.getModel().getRenderer()).clearSelection();
    }
}

