/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.components;

import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class TypewriterLabel
extends JLabel {
    private long characterInteval = 70L;
    private int index;
    private String myText;
    private Timer timer;
    private TimerTask task;

    public void setText(String value, long delay) {
        this.myText = value;
        this.stopAnimation();
        this.doAnimation(delay);
    }

    @Override
    public void setText(String value) {
        if (this.characterInteval <= 0L) {
            super.setText(value);
        } else {
            this.setText(value, 0L);
        }
    }

    private void update() {
        ++this.index;
        if (this.index == this.myText.length()) {
            this.stopAnimation();
        } else {
            super.setText(this.myText.substring(0, this.index));
        }
    }

    private void stopAnimation() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
            this.index = this.myText.length();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TypewriterLabel.super.setText(TypewriterLabel.this.myText.substring(0, TypewriterLabel.this.index));
                }
            });
        }
    }

    private void doAnimation(long delay) {
        this.index = 0;
        if (this.timer == null) {
            this.timer = new Timer(true);
        }
        this.task = new TimerTask(){

            @Override
            public void run() {
                TypewriterLabel.this.update();
            }
        };
        this.timer.schedule(this.task, delay <= 0L ? 50L : delay, this.characterInteval);
    }

    public void setCharacterInterval(long value) {
        this.characterInteval = value;
    }
}

