/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import au.com.ordermate.gui.adminkit.AdminGuiUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.internationalization.Internationalization;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.JXMonthView;
import waitermate.guikit.dialogs.Dialogs;
import waitermate.guikit.dialogs.PopupWindow;

public class CalendarDialog
extends JPanel
implements ActionListener {
    protected JXMonthView monthView;
    protected Date selectedDate;
    protected PopupWindow parentWindow;
    private Signal back = Signals.createSignal();
    private Signal backYear = Signals.createSignal();
    private Signal forwardYear = Signals.createSignal();
    private Signal forwardMonth = Signals.createSignal();

    public CalendarDialog() {
        this(new Date());
    }

    public CalendarDialog(Date startDate) {
        this.monthView = new JXMonthView(startDate);
        this.monthView.addActionListener((ActionListener)this);
        this.monthView.setName("monthCalenderView");
        this.back.connect((Object)this, "gotBack");
        this.backYear.connect((Object)this, "gotBackYear");
        this.forwardYear.connect((Object)this, "gotForwardYear");
        this.forwardMonth.connect((Object)this, "gotForwards");
        this.parentWindow = new PopupWindow();
        this.parentWindow.setOkButtonVisible(false);
        this.parentWindow.setText("Select Date:");
        this.parentWindow.setComponent((JComponent)this.monthView);
        this.parentWindow.setCancelButtonText(Internationalization.getLiteralFor((String)"CANCEL"));
        this.parentWindow.setCancelButtonVisible(true);
        this.parentWindow.getNavBar().cancel.connect((Object)this, "gotCancel");
        this.parentWindow.setOkButtonVisible(false);
        this.parentWindow.getNavBar().addLeft(this.parentWindow.getNavBar().getCancelButton());
        this.parentWindow.getNavBar().addLeft(this.parentWindow.getNavBar().constructButton((Icon)IconLoader.get((String)"/waitermate/images/leftarrow.png"), "", "backMonthButton", this.back));
        this.parentWindow.getNavBar().addLeft(new JLabel("Month"));
        this.parentWindow.getNavBar().addLeft(this.parentWindow.getNavBar().constructButton((Icon)IconLoader.get((String)"/waitermate/images/rightarrow.png"), "", "forwardMonthButton", this.forwardMonth));
        this.parentWindow.getNavBar().addRight(this.parentWindow.getNavBar().constructButton((Icon)IconLoader.get((String)"/waitermate/images/leftarrow.png"), "", "backYearButton", this.backYear));
        this.parentWindow.getNavBar().addRight(new JLabel("Year"));
        this.parentWindow.getNavBar().addRight(this.parentWindow.getNavBar().constructButton((Icon)IconLoader.get((String)"/waitermate/images/rightarrow.png"), "", "forwardYearButton", this.forwardYear));
        AdminGuiUtils.getInstance().standardMonthViewSetup(this.monthView);
    }

    public void gotBack() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.monthView.getSelectionDate());
        cal.add(2, -1);
        this.setSelectedDate(cal.getTime());
    }

    public void gotForwards() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.monthView.getSelectionDate());
        cal.add(2, 1);
        this.setSelectedDate(cal.getTime());
    }

    public void gotBackYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.monthView.getSelectionDate());
        cal.add(1, -1);
        this.setSelectedDate(cal.getTime());
    }

    public void gotForwardYear() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.monthView.getSelectionDate());
        cal.add(1, 1);
        this.setSelectedDate(cal.getTime());
    }

    protected void setSelectedDate(Date selectedDate) {
        if (selectedDate != null) {
            this.monthView.setFirstDisplayedDay(selectedDate);
            this.monthView.setSelectionDate(selectedDate);
        }
    }

    public void gotCancel() {
        this.parentWindow.stop();
    }

    public void setup(Date startDate, Date[] flaggedDates) {
        this.monthView.setSelectionDate(startDate);
        this.monthView.setFlaggedDates(flaggedDates == null ? new Date[]{} : flaggedDates);
    }

    public Date getSelectedDate() {
        return this.selectedDate != null ? new Date(this.selectedDate.getTime()) : null;
    }

    public Date start() {
        boolean toReturn;
        if (this.monthView.getSelectionDate() == null) {
            this.monthView.setSelectionDate(new Date());
        }
        if (toReturn = Dialogs.displayDialog(this.parentWindow, null, null)) {
            return this.getSelectedDate();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.monthView)) {
            this.gotDate();
        }
    }

    protected void gotDate() {
        this.selectedDate = this.monthView.getSelectionDate();
        this.parentWindow.getNavBar().ok.emit();
    }

    public JXMonthView getJXMonthView() {
        return this.monthView;
    }
}

