/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.database.sales.Customer;
import ordermate.gui.scroll.Renderer;
import ordermate.internationalization.Internationalization;
import waitermate.guikit.dialogs.Dialogs;

class CustomerCommentRenderer
implements Renderer {
    private boolean canModify;

    public CustomerCommentRenderer(boolean allowModify) {
        this.canModify = allowModify;
    }

    public Component createComponent() {
        return new CustomerCommentRenderPanel();
    }

    public void setupComponent(Component component, Object object, int index) {
        CustomerCommentRenderPanel panel = (CustomerCommentRenderPanel)component;
        panel.setEditable(this.canModify);
        panel.setCustomer((Customer)object);
    }

    private static class CustomerCommentRenderPanel
    extends JPanel
    implements ActionListener {
        private JButton editButton;
        private JButton clearButton;
        private JLabel customerLabel;
        private JLabel commentLabel;
        Customer customer;

        public CustomerCommentRenderPanel() {
            super((LayoutManager)new GraphPaperLayout(10, 5));
            this.setupComponents();
        }

        private void setupComponents() {
            this.customerLabel = new JLabel();
            this.customerLabel.setForeground(Color.GRAY);
            this.customerLabel.setHorizontalAlignment(2);
            this.commentLabel = new JLabel();
            this.commentLabel.setHorizontalAlignment(2);
            this.editButton = new JButton(IconLoader.get((String)"/waitermate/guikit/images/keyboard.png"));
            this.editButton.addActionListener(this);
            this.clearButton = new JButton(IconLoader.get((String)"/waitermate/guikit/images/clear.png"));
            this.clearButton.addActionListener(this);
            this.add((Component)this.customerLabel, new Rectangle(0, 0, 8, 2));
            this.add((Component)this.commentLabel, new Rectangle(0, 2, 8, 3));
            this.add((Component)this.editButton, new Rectangle(8, 0, 1, 5));
            this.add((Component)this.clearButton, new Rectangle(9, 0, 1, 5));
        }

        void setCustomer(Customer newCustomer) {
            this.customer = newCustomer;
            if (this.customer != null) {
                this.customerLabel.setText(this.customer.getName());
                this.commentLabel.setText(this.customer.getComments());
            } else {
                this.customerLabel.setText("");
                this.commentLabel.setText(Internationalization.getLiteralFor((String)"NO_COMMENT_IN_EXCLAMATION"));
            }
        }

        void setEditable(boolean value) {
            this.editButton.setEnabled(value);
            this.clearButton.setEnabled(value);
        }

        private void editComment() {
            String text = Dialogs.getString(Internationalization.getLiteralFor((String)"COMMENT") + ":", this.customer.getComments(), true, Internationalization.getLiteralFor((String)"CUSTOMER_COMMENT"));
            if (text != "\u0000") {
                if (this.customer != null) {
                    this.customer.setComments(text);
                    this.customer.save();
                }
                this.commentLabel.setText(text);
                this.commentLabel.setForeground(null);
            }
        }

        private void clearComment() {
            if (this.customer != null) {
                this.customer.setComments(null);
                this.customer.save();
            }
            this.commentLabel.setForeground(Color.GRAY);
            this.commentLabel.setText(Internationalization.getLiteralFor((String)"NO_COMMENT_IN_EXCLAMATION"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.editButton) {
                this.editComment();
            } else if (source == this.clearButton) {
                this.clearComment();
            }
        }
    }
}

