/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.gui.keyboard.Keyboard;
import ordermate.gui.themes.OrderMateTheme;

public class KeyboardDialog
extends JPanel {
    private static final int LABEL_PAD = 30;
    private JLabel unitLabel;
    private JLabel hintLabel;
    private JPanel labelPanel;
    protected JLabel valueLabel;
    protected Keyboard keyboard = new Keyboard(false);

    public KeyboardDialog() {
        this("");
    }

    private void setGBC(GridBagConstraints gbc, int x, int y, int width) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.anchor = 17;
        gbc.weighty = 1.0;
        gbc.ipadx = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
    }

    public KeyboardDialog(String label) {
        this.labelPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.unitLabel = new JLabel(label);
        this.unitLabel.setFont(OrderMateTheme.getMediumFont());
        this.unitLabel.setForeground(Color.DARK_GRAY);
        this.unitLabel.setOpaque(true);
        this.valueLabel = new JLabel();
        this.valueLabel.setFont(OrderMateTheme.getMediumFont());
        this.hintLabel = new JLabel();
        this.hintLabel.setFont(OrderMateTheme.getSmallFont());
        this.hintLabel.setForeground(Color.GRAY);
        this.setGBC(gbc, 0, 0, 1);
        gbc.fill = 0;
        this.labelPanel.add((Component)this.unitLabel, gbc);
        this.setGBC(gbc, 1, 0, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.labelPanel.add((Component)this.valueLabel, gbc);
        this.setGBC(gbc, 0, 1, 2);
        gbc.fill = 0;
        this.labelPanel.add((Component)this.hintLabel, gbc);
        this.labelPanel.setPreferredSize(new Dimension(720, 100));
        this.labelPanel.setMaximumSize(new Dimension(720, 100));
        this.setLayout(new BorderLayout());
        this.add((Component)this.labelPanel, "North");
        this.add((Component)this.keyboard, "Center");
        this.connectSignals();
    }

    protected void connectSignals() {
        this.keyboard.updated.connect((Object)this, "gotText");
    }

    public void gotText(String value) {
        if (value != null) {
            this.valueLabel.setText("<html>" + value + "</html>");
        } else {
            this.valueLabel.setText("<html></html>");
        }
    }

    public String getValue() {
        return this.keyboard.getValue();
    }

    public void setValue(String text) {
        this.gotText(text);
        this.keyboard.setValue(text);
    }

    public void clear() {
        this.valueLabel.setText("");
        this.keyboard.clear();
        this.keyboard.setShift(true);
        this.keyboard.setCaps(false);
    }

    public boolean hasValue() {
        return this.getValue().length() > 0;
    }

    public void setLabel(String newLabel) {
        this.unitLabel.setText(newLabel);
    }

    public void setHint(String hint) {
        this.hintLabel.setText(hint);
    }
}

