/*
 * Decompiled with CFR 0.152.
 */
package waitermate.guikit.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.gui.keyboard.KeyboardForSamsung;
import ordermate.gui.themes.OrderMateTheme;

public class KeyboardDialogForSamsung
extends JPanel {
    private static final int LABEL_PAD = 30;
    private JLabel unitLabel;
    private JPanel labelPanel;
    protected JLabel valueLabel;
    protected KeyboardForSamsung keyboard = new KeyboardForSamsung(false);

    public KeyboardDialogForSamsung() {
        this("");
    }

    public KeyboardDialogForSamsung(String label) {
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(new BoxLayout(this.labelPanel, 0));
        this.unitLabel = new JLabel(label);
        this.unitLabel.setFont(OrderMateTheme.getMediumFont());
        this.unitLabel.setForeground(Color.DARK_GRAY);
        this.unitLabel.setOpaque(true);
        this.unitLabel.setVerticalAlignment(1);
        this.valueLabel = new JLabel();
        this.valueLabel.setFont(OrderMateTheme.getMediumFont());
        this.valueLabel.setVerticalAlignment(1);
        this.labelPanel.setLayout(new BorderLayout(5, 5));
        this.labelPanel.add((Component)this.unitLabel, "West");
        this.labelPanel.add((Component)this.valueLabel, "Center");
        this.labelPanel.setPreferredSize(new Dimension(720, 120));
        this.labelPanel.setMaximumSize(new Dimension(720, 100));
        this.setLayout(new BorderLayout());
        this.add((Component)this.labelPanel, "North");
        this.add((Component)this.keyboard, "Center");
        this.connectSignals();
    }

    protected void connectSignals() {
        this.keyboard.updated.connect((Object)this, "gotText");
    }

    public void gotText(String value) {
        if (value != null) {
            this.valueLabel.setText("<html>" + value + "</html>");
        } else {
            this.valueLabel.setText("<html></html>");
        }
    }

    public String getValue() {
        return this.keyboard.getValue();
    }

    public void setValue(String text) {
        this.gotText(text);
        this.keyboard.setValue(text);
    }

    public void clear() {
        this.valueLabel.setText("");
        this.keyboard.clear();
        this.keyboard.setShift(true);
        this.keyboard.setCaps(false);
    }

    public boolean hasValue() {
        return this.getValue().length() > 0;
    }

    public void setLabel(String newLabel) {
        this.unitLabel.setText(newLabel);
    }
}

